<?php

namespace App\Http\Controllers;

use App\Models\Accesories;
use Illuminate\Http\Request;
use App\Models\Accesory;

class AccesoriesController extends Controller
{
    public function index()
    {
        $title = 'Accessories List';
        $accesories = Accesories::all();
        return view('backend.pages.accesories.accesories', compact('accesories', 'title'));
    }

    public function create()
    {
        return view('backend.pages.accesories.accesoriescreate');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'unit' => 'required|string|max:100',
        ]);

        $accessory = new Accesories();
        $accessory->name = $request->name;
        $accessory->unit = $request->unit;
        $accessory->save();

        return redirect()->route('accesories.list')->with('success', 'Accessory created successfully.');
    }

    public function edit($id)
    {
        $accessory = Accesories::findOrFail($id);
        return view('backend.pages.accesories.edit', compact('accessory'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'unit' => 'required|string|max:100',
        ]);

        $accessory = Accesories::findOrFail($id);
        $accessory->name = $request->name;
        $accessory->unit = $request->unit;
        $accessory->save();

        return redirect()->route('accesories.list')->with('success', 'Accessory updated successfully.');
    }

    public function delete($id)
    {
        $accessory = Accesories::findOrFail($id);
        $accessory->delete();

        return redirect()->route('accesories.list')->with('success', 'Accessory deleted successfully.');
    }
}
