<?php

namespace App\Http\Controllers;

use App\Models\Accesories;
use Illuminate\Http\Request;
use App\Models\Accesory;
use App\Models\Branch;
use Illuminate\Support\Facades\Auth;

class AccesoriesController extends Controller
{
    public function index()
    {
        $title = 'Accessories List';
        // $accesories = Accesories::all();
        
 $auth = Auth::user();

        $userRole = $auth->role_id;
        if ($userRole > 1) {
            $accesories = Accesories::where('branch_id', $auth->branch_id)->get();
        } else {
            $accesories = Accesories::all();
        }
        return view('backend.pages.accesories.accesories', compact('accesories', 'title'));
    }

    public function create()
    {
         $auth = Auth::user();

        $userRole = $auth->role_id;
        if ($userRole > 1) {

            $branchs = Branch::where("id", $auth->branch_id)->get();
        } else {

            $branchs = Branch::where("parent_id", 0)->get();
        }
        return view('backend.pages.accesories.accesoriescreate', compact('branchs'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'unit' => 'required|string|max:100',
        ]);

        $accessory = new Accesories();
        $accessory->name = $request->name;
        $accessory->unit = $request->unit;
        $accessory->branch_id = $request->branch_id;
        $accessory->save();

        return redirect()->route('accesories.list')->with('success', 'Accessory created successfully.');
    }

    public function edit($id)
    {
        $accessory = Accesories::findOrFail($id);
         $auth = Auth::user();

        $userRole = $auth->role_id;
        if ($userRole > 1) {

            $branchs = Branch::where("id", $auth->branch_id)->get();
        } else {

            $branchs = Branch::where("parent_id", 0)->get();
        }
        return view('backend.pages.accesories.edit', compact('accessory','branchs'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'unit' => 'required|string|max:100',
        ]);

        $accessory = Accesories::findOrFail($id);
        $accessory->name = $request->name;
        $accessory->unit = $request->unit;
        $accessory->branch_id = $request->branch_id;
        $accessory->save();

        return redirect()->route('accesories.list')->with('success', 'Accessory updated successfully.');
    }

    public function delete($id)
    {
        $accessory = Accesories::findOrFail($id);
        $accessory->delete();

        return redirect()->route('accesories.list')->with('success', 'Accessory deleted successfully.');
    }
}
