<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Attendance as ModelsAttendance;
use App\Models\Employee;
use Illuminate\Http\Request;

class Attendance extends Controller
{
   function getEmployee(){
     $employee = Employee::get();
     return response()->json($employee);
   }

   function getAttendance(Request $request){
     $attendance = ModelsAttendance::where('emplyee_id', $request->id)->whereDate('date', $request->date)->first();
     return response()->json($attendance);
   }
   function updateAttendance(Request $request){
      $attendance = ModelsAttendance::where('emplyee_id', $request->id)->whereDate('date', $request->date)->update([
         'date'          => $request->date,
         'sign_out'      => $request->sign_out,
      ]);
     return response()->json($attendance);
   }

   function storeAttendance(Request $request){
    try {
      $employee = Employee::find($request->id);
        $attendance = ModelsAttendance::where('emplyee_id', $request->id)->whereDate('date', $request->date)->insert([
          'emplyee_id'    => $request->id,
          'date'          => $request->date,
          'sign_in'       => $request->sign_in,
          'branch_id'       => $employee->branch_id ?? 0,
          'sign_out'      => '00.00',
        ]);            
    } catch (\Throwable $th) {
      dd($th->getMessage());
    }

     return response()->json($attendance);
   }
}
