<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;


class Order extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    public function buyer(): BelongsTo {
        return $this->belongsTo(Buyer::class, 'buyer_id', 'id');
    }

    public function details(): HasMany {
        return $this->hasMany(OrderDetails::class, 'order_id', 'id');
    }

    public function approvedUser(): BelongsTo {
        return $this->belongsTo(User::class, 'approved_by', 'id');
    }

    public function rejectedUser(): BelongsTo {
        return $this->belongsTo(User::class, 'rejected_by', 'id');
    }

    public function attachments(): HasMany {
        return $this->hasMany(OrderAttachment::class, 'order_id', 'id');
    }

    public function proformaInvoice(): HasOne {
        return $this->hasOne(ProformaInvoice::class, 'order_id', 'id');
    }

    public function project(): HasOne {
        return $this->hasOne(Project::class, 'order_id', 'id');
    }
}
