<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\QuickSalesProduct;


class QuickSales extends Model
{
    use HasFactory;
    protected $table = 'quick_sales';

    protected $fillable = [
        'date',
        'biller',
        'customer_name',
        'phone_number',
        'email',
        'address',
        'total_amount',
        'discount',
        'shipping_charge',
        'received_amount',
        'due_balance',
        'payment_status',
        'delivery_status',
        'ledger_id',
        'branch_id'
    ];

    public function products()
    {
        return $this->hasMany(QuickSalesProduct::class, 'sale_id', 'id');
    }
    public function customer(){

        return $this->belongsTo(ChartOfAccount::class,'ledger_id','id');
    }
}
