<?php

namespace App\Repositories\InventorySetup;

use App\Helpers\Helper;
use Illuminate\Support\Facades\Auth;
use App\Models\Category;
use phpDocumentor\Reflection\PseudoTypes\False_;

class CategoryRepositories
{
    /**
     * @var user_id
     */
    private $user_id;
    /**
     * @var Category
     */
    private $category;
    /**
     * CourseRepository constructor.
     * @param category $category
     */
    public function __construct(Category $category)
    {
        $this->category = $category;
        //$this->middleware(function ($request, $next) {
        $this->user_id = 1; //auth()->user()->id;
        //  return $next($request);
        //});
    }
    /**
     * @param $request
     * @return mixed
     */
    
    public function getAllList()
    {
         $auth = Auth::user();
        $userRole = $auth->role_id;
         if ($userRole > 1) {
        $result = $this->category::where('created_by',$auth->id)->with('parent')->latest()->get();
         }else{
             $result = $this->category::with('parent')->latest()->get();
         }
        return $result;
    }
    
    /**
     * @param $request
     * @return mixed
     */

    public function getList($request)
    {
        $columns = array(
            0 => 'id',
            1 => 'name',
        );
            
        $edit = Helper::roleAccess('inventorySetup.category.edit') ? 1 : 0;
        $delete = Helper::roleAccess('inventorySetup.category.destroy') ? 1 : 0;
        $view = Helper::roleAccess('inventorySetup.category.show') ? 0 : 0;
        $ced = $edit + $delete + $view;
       $auth = Auth::user();
       $userRole = $auth->role_id;
         if ($userRole > 1) {
           $totalData = $this->category::where('branch_id',$auth->branch_id)->count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $categorys = $this->category::where('branch_id',$auth->branch_id)->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->category::where('branch_id',$auth->branch_id)->count();
        } else {
            $search = $request->input('search.value');
            $categorys = $this->category::where('branch_id',$auth->branch_id)->where('name', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->category::where('branch_id',$auth->branch_id)->where('name', 'like', "%{$search}%")->count();
        }



         }else{
              $totalData = $this->category::count();

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $categorys = $this->category::offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                //->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->category::count();
        } else {
            $search = $request->input('search.value');
            $categorys = $this->category::where('name', 'like', "%{$search}%")
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                // ->orderBy('status', 'desc')
                ->get();
            $totalFiltered = $this->category::where('name', 'like', "%{$search}%")->count();
        }


         }
      


        $data = array();
        if ($categorys) {
            foreach ($categorys as $key => $category) {
                $nestedData['id'] = $key + 1;
                $nestedData['parent_id'] = $category->parent->name ?? "Root";
                $nestedData['name'] = $category->name;
                if ($category->status == 'Active') :
                    $status = '<input class="status_row" status_route="' . route('inventorySetup.category.status', [$category->id, 'Inactive']) . '"   id="toggle-demo" type="checkbox" name="my-checkbox" checked data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                else :
                    $status = '<input  class="status_row" status_route="' . route('inventorySetup.category.status', [$category->id, 'Active']) . '"  id="toggle-demo" type="checkbox" name="my-checkbox"  data-bootstrap-switch data-off-color="danger" data-on-color="success">';
                endif;
                $nestedData['status'] = $status;
                if ($ced != 0) :
                    if ($edit != 0)
                        $edit_data = '<a href="' . route('inventorySetup.category.edit', $category->id) . '" class="btn btn-xs btn-default"><i class="fa fa-edit" aria-hidden="true"></i></a>';
                    else
                        $edit_data = '';
                    if ($view != 0)
                        $view_data = '<a href="' . route('inventorySetup.category.show', $category->id) . '" class="btn btn-xs btn-default"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                    else
                        $view_data = '';
                    if ($delete != 0)
                        $delete_data = '<a delete_route="' . route('inventorySetup.category.destroy', $category->id) . '" delete_id="' . $category->id . '" title="Delete" class="btn btn-xs btn-default delete_row uniqueid' . $category->id . '"><i class="fa fa-times"></i></a>';
                    else
                        $delete_data = '';
                    $nestedData['action'] = $edit_data . ' ' . $view_data . ' ' . $delete_data;
                else :
                    $nestedData['action'] = '';
                endif;
                $data[] = $nestedData;
            }
        }
        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );

        return $json_data;
    }

    /**
     * @param $request
     * @return mixed
     */
    
    public function details($id)
    {
        $result = $this->category::find($id);
        return $result;
    }

    public function store($request)
    {
        $category = new $this->category();
        $category->name = $request->name;
          $category->branch_id = $request->branch_id;
        $category->parent_id = $request->parent_id;
        $category->status = 'Active';
        $category->created_by = Auth::user()->id;
        $category->save();
        return $category;
    }

    public function update($request, $id)
    {
        $category = $this->category::findOrFail($id);
        $category->name = $request->name;
        $category->parent_id = $request->parent_id;
         $category->branch_id = $request->branch_id;
        $category->status = 'Active';
        $category->updated_by = Auth::user()->id;
        $category->save();
        return $category;
    }

    public function statusUpdate($id, $status)
    {
        $category = $this->category::find($id);
        $category->status = $status;
        $category->save();
        return $category;
    }

    public function destroy($id)
    {
        $category = $this->category::find($id);
        $category->delete();
        return true;
    }
}
