<?php

namespace App\Services\Project;

use App\Repositories\Project\ProjectRepositories;
use App\Rules\PhoneNumberValidationRules;
use Illuminate\Support\Facades\Validator;

class ProjectService
{

    /**
     * @var ProjectRepositories
     */
    private $systemRepositories;

    /**
     * AdminCourseService constructor.
     * @param ProjectRepositories $branchRepositories
     */
    public function __construct(ProjectRepositories $systemRepositories)
    {
        $this->systemRepositories = $systemRepositories;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function getList($request)
    {
        return $this->systemRepositories->getList($request);
    }

    /**

      /**
     * @param $request
     * @return mixed
     */
    public function statusUpdate($request, $id)
    {
        return $this->systemRepositories->statusUpdate($request, $id);
    }

    public function statusValidation($request)
    {
        return [
            'id' => 'required',
            'status' => 'required',
        ];
    }
    public function completeValidation($request)
    {
        return [
            'close_date' => 'required',
            'projectid' => 'required',
        ];
    }

    /**
     * @param $request
     * @return array
     */
    public function storeValidation($request)
    {

        return [
            'projectCode' => 'required',
            'name' => 'required',
            'manager_id' => 'required',
            'budget' => 'required',
            'branch_id' => 'nullable',
            'customer_id' => 'required',
            'start_date' => 'required',
            // 'end_date' => 'required',
            'address' => 'required',
            'status' => 'nullable',
            'estimate_profit'
        ];
    }

    /**
     * @param $id
     * @return array
     */
    public function updateValidation($request, $id)
    {

        return [

            'name' => 'required',
            'manager_id' => 'required',
            'budget' => 'required',
            'branch_id' => 'nullable',
            'customer_id' => 'required',
            'start_date' => 'required',
            // 'end_date' => 'required',
            'address' => 'required',
            'status' => 'nullable',
            'estimate_profit'
        ];
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function store($request)
    {
        // dd($request->all());
        return $this->systemRepositories->store($request);
    }

    public function completestore($request)
    {
        // dd($request->all());
        return $this->systemRepositories->completestore($request);
    }

        /**
     * @param $request
     * @return array
     */
    public function generateValidation($request) {
        return [
            'projectCode' => 'required',
            'name' => 'required',
            'manager_id' => 'required',
            'budget' => 'required',
            'branch_id' => 'nullable',
            // 'customer_id' => 'required',
            'invoice_id' => 'nullable',
            'order_id' => 'required',
            'start_date' => 'required',
            // 'end_date' => 'required',
            'address' => 'required',
            'status' => 'nullable',
            'estimate_profit' => 'nullable'
        ];
    }

    
    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function generate($request) {
        // dd($request->all());
        return $this->systemRepositories->generate($request);
    }

    /**
     * @param $request
     * @return \App\Models\Currency
     */
    public function details($id)
    {

        return $this->systemRepositories->details($id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function update($request, $id)
    {
        return $this->systemRepositories->update($request, $id);
    }

    /**
     * @param $request
     * @param $id
     */
    public function destroy($id)
    {
        return $this->systemRepositories->destroy($id);
    }
}
