<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumStockInTotalGrandTotal extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('stockins', function (Blueprint $table) {
           $table->double('totalKg',8,2)->nullable();
           $table->integer('ttlqty')->nullable();
           $table->double('ttlunitprice',8,2)->nullable();
           $table->double('grandtotal',8,2)->nullable();
           $table->double('grandsubTotaltotal',8,2)->nullable();
           $table->double('previouse_due_amount',8,2)->nullable();
           $table->double('labor_bill',8,2)->nullable();
           $table->double('ngrandTotal',8,2)->nullable();
           $table->integer('advance_ledger_id')->nullable();
           $table->double('advance',8,2)->nullable();
           $table->double('finalDue',8,2)->nullable();
           $table->longText('notation')->nullable();
           $table->string('voucher')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('stockins', function (Blueprint $table) {
             $table->dropColumn([
            'totalKg',
            'ttlqty',
            'ttlunitprice',
            'grandtotal',
            'grandsubTotaltotal',
            'previouse_due_amount',
            'labor_bill',
            'ngrandTotal',
            'advance_ledger_id',
            'advance',
            'finalDue',
            'notation',
            'voucher',
        ]);
        });
    }
}
