<?php

namespace Database\Seeders;

use App\Models\Status;
use Illuminate\Database\Seeder;

class StatusSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {
        $statuses = [
            [ 'title' => 'Pending' ],
            [ 'title' => 'Confirm' ],
            [ 'title' => 'Processing' ],
            [ 'title' => 'Production' ],
            [ 'title' => 'Packaging' ],
            [ 'title' => 'Delivered' ],
            [ 'title' => 'Completed' ],
        ];

        for ($i = 0; $i < count($statuses); $i++) {
            $statuses[$i]['order_by'] = $i + 1;
            Status::create($statuses[$i]);
        }
    }
}
