@extends('backend.layouts.master')

@section('title')
  {{ __('Dashboard Page - Buyer Panel') }}
@endsection
  <style>
    .small-box>.small-box-footer {
    border: none;
    width: 100%;
  }
</style>

@section('navbar-content')
  <div class="content-header">
    
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Dashboard') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item active">
              <a href="javascript:void(0)">{{ __('Dashboard') }}</a>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  
  <section class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-body">
          <h4>{{ __('Hello') . ' ' . $buyer->name }}</h4>
          @if ($buyer->status == 'Pending')
            <h5>{{ __('Your account is pending approval. Please contact support.') }}</h5>
          @endif
          <p></p>
        </div>
      </div>
    </div>
  </section>

  @if ($buyer->status == 'Approved')
  <div class="row">
      <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-default">
              <div class="inner">
                  <h3>{{ count($Order) }}</h3>
                  <p>Total Orders</p>
              </div>
              <div class="icon">
                  <i class="ion ion-pie-graph"></i>
              </div>
              <button href="" class="small-box-footer bg-success">More info <i class="fas fa-arrow-circle-right"></i></button>
          </div>
      </div>
      <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-default">
              <div class="inner">
                  <h3>{{ count($approve_Order) }}</h3>
                  <p>Approve Orders</p>
              </div>
              <div class="icon">
                  <i class="ion ion-pie-graph"></i>
              </div>
              <button href="" class="small-box-footer bg-success">More info <i class="fas fa-arrow-circle-right"></i></button>
          </div>
      </div>
      <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-default">
              <div class="inner">
                  <h3>{{ count($confrim_Order) }}</h3>
                  <p>Confrim  Orders</p>
              </div>
              <div class="icon">
                  <i class="ion ion-pie-graph"></i>
              </div>
              <button href="" class="small-box-footer bg-success">More info <i class="fas fa-arrow-circle-right"></i></button>
          </div>
      </div>
      <div class="col-lg-3 col-6">
          <!-- small box -->
          <div class="small-box bg-default">
              <div class="inner">
                  <h3>{{ count($Pending_Order) }}</h3>
                  <p>pending  Orders</p>
              </div>
              <div class="icon">
                  <i class="ion ion-pie-graph"></i>
              </div>
              <button href="" class="small-box-footer bg-success">More info <i class="fas fa-arrow-circle-right"></i></button>
          </div>
      </div>
  </div>
  @endif
  

@endsection
