@extends('backend.layouts.master')

@section('title')
  {{ __('Inventory') . ' - ' . $title}} 
@endsection


@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Color') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('inventorySetup.color.index'))
              <li class="breadcrumb-item">
                <a href="{{route('inventorySetup.color.index')}}">{{ __('Color List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ __('Edit Inventory') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">Inventory List</h3>
          <div class="card-tools">
            @if(helper::roleAccess('inventorySetup.color.create'))
              <a class="btn btn-default" href="{{ route('inventorySetup.color.create') }}">
                <i class="fas fa-plus"></i>
                <span>{{ __('Add New') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('inventorySetup.color.update',$editInfo->id) }}" novalidate>
            @csrf
            <div class="form-row">
              <div class="col-md-6 mb-3">
                <label for="validationCustom01">Name * :</label>
                <input type="text" name="name" class="form-control form-control-sm" id="validationCustom01" placeholder="Name" value="{{ $editInfo->name }}">
                @error('name')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>
              <div class="col-md-6 mb-3">
                <label for="validationCustom01">{{ __('Status * :') }}</label>
                <select class="form-control select2" name="status">
                  <option value="Pending" {{ $editInfo->status == 'Pending' ? 'selected' : '' }} >{{ __('--Select--') }}</option>
                  <option value="Display" {{ $editInfo->status == 'Display' ? 'selected' : '' }} >{{ __('Display') }}</option>
                  <option value="Hidden" {{ $editInfo->status == 'Hidden' ? 'selected' : '' }} >{{ __('Hidden') }}</option>
                </select>
                @error('status')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>
            </div>
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp;{{ __('Update') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection