@extends('backend.layouts.master')
@section('title')
Sale - {{$title}}
@endsection

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
</style>
@endsection

@section('navbar-content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
          
             <div class="col-sm-6" style="display: flex;gap:10px;border: 1px solid red;
    padding: 5px;
}">
                   @if (!empty($customer->logo))
    <img src="{{ asset('/backend/logo/' . $customer->logo) }}"
         style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
         alt="Supplier Image">
@else
    <img src="{{ asset('/backend/logo/default.png') }}"
         style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 3px solid #ccc;"
         alt="Default Supplier Image">
@endif

                    <div style="font-weight: bold;font-size:24px; font-weight:bold">
                        <p style="padding: 2px; margin-bottom: -12px;">{{ $customer->name }}</p>
                        <p style="padding: 2px; margin-bottom: -12px;">{{ $customer->phone }}</p>
                        <p style="padding: 2px; margin-bottom: -12px;"> {{ $customer->address }}</p>
                    </div>

                </div><!-- /.col -->
                 <div class="col-sm-2" style="text-align: center; font-weight:900">
                   
                </div>
            <!-- /.col -->
            <div class="col-sm-4" style="text-align: center;">
    <div style="border: 1px solid #ccc; padding: 10px; margin-bottom: 5px; border-radius: 5px;">
        Total DUE
    </div>
    <div style="border: 1px solid #ccc; padding: 10px; border-radius: 5px;">
        {{ $totalDue }}
    </div>
</div>

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Sale List</h3>
                <div class="card-tools">
                   
                    <span id="buttons"></span>
                    <a class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="table-responsive">
                  <div class="mb-3" style="display: flex;gap:10px">
                    <div>
<label for="from_date">From:</label>
                        <input type="date" id="from_date" class="form-control" name="from_date">
                    </div>
                        
                       <div>
                         <label for="to_date">To:</label>
                        <input type="date" id="to_date" class="form-control" name="to_date">
                       </div>
                    </div>
                    <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                        <thead>
                            <tr>
                                 <th>SL</th>
                                <th>Invoice No</th>
                            
                                <th>Date</th>
                              
                          
                                <th>Total Bill</th>
                              <th>Total Due</th>
                                <th>Action</th>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th>SL</th>
                                <th>Invoice No</th>
                            
                                <th>Date</th>
                              
                          
                                <th>Total Bill</th>
                              <th>Total Due</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- /.card-body -->
            <div class="card-footer">

            </div>
        </div>
    </div>
    <!-- /.col-->
</div>
@endsection
@section('scripts')
@include('backend.pages.inventories.customer.saleScript')
@endsection
