@extends('backend.layouts.master')

@section('title')
    Settings - {{ $title }}
@endsection
<style>
    /* Updated CSS for better image preview */
    .image-preview-container {
        position: relative;
        display: inline-block;
        margin: 10px 0;
    }

    .image-preview {
        max-width: 200px;
        max-height: 200px;
        border: 2px dashed #ddd;
        border-radius: 8px;
        padding: 10px;
        /* Show preview if image exists, hide if not */
        display: {{ $editInfo->logo && file_exists(public_path('/backend/logo/' . $editInfo->logo)) ? 'block' : 'none' }};
    }

    .image-preview img {
        max-width: 100%;
        max-height: 100%;
        border-radius: 4px;
        display: block;
    }

    .image-remove-btn {
        position: absolute;
        top: 5px;
        right: 5px;
        background: #dc3545;
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
    }

    .image-remove-btn:hover {
        background: #c82333;
    }

    .file-input-wrapper {
        position: relative;
        overflow: hidden;
        display: inline-block;
        width: 100%;
    }

    .file-input-wrapper input[type=file] {
        position: absolute;
        left: -9999px;
    }

    .file-input-label {
        display: block;
        padding: 10px 15px;
        cursor: pointer;
        background: #f8f9fa;
        border: 2px dashed #ddd;
        border-radius: 8px;
        text-align: center;
        transition: all 0.3s ease;
    }

    .file-input-label:hover {
        background: #e9ecef;
        border-color: #007bff;
    }

    .file-input-label i {
        font-size: 24px;
        color: #6c757d;
        margin-bottom: 5px;
    }

    .file-name {
        margin-top: 5px;
        font-size: 12px;
        color: #6c757d;
    }

    /* Additional styles for existing file display */
    .existing-file-info {
        background: #e8f5e8;
        border: 1px solid #d4edda;
        border-radius: 4px;
        padding: 10px;
        margin-top: 10px;
        font-size: 12px;
        color: #155724;
    }

    .existing-file-info i {
        color: #28a745;
        margin-right: 5px;
    }
</style>

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Settings </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('settings.customer.index'))
                            <li class="breadcrumb-item"><a href="{{ route('inventorySetup.customer.index') }}">Customer
                                    List</a>
                            </li>
                        @endif
                        <li class="breadcrumb-item active"><span>Edit Customer</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Customer Edit</h3>
                    <div class="card-tools">
                        @if (helper::roleAccess('inventorySetup.customer.create'))
                            <a class="btn btn-default" href="{{ route('inventorySetup.customer.create') }}"><i
                                    class="fas fa-plus"></i>
                                Add New</a>
                        @endif
                        <span id="buttons"></span>

                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">

                    <form class="needs-validation" method="POST"
                        action="{{ route('inventorySetup.customer.update', $editInfo->id) }}" enctype="multipart/form-data"
                        novalidate>
                        @csrf
                        <div class="form-row">
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Contact Persion * :</label>
                                <input type="text" name="name" class="form-control" id="validationCustom01"
                                    placeholder="Contact Persion" value="{{ $editInfo->name }}">
                                @error('name')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Company Name :</label>
                                <input type="text" name="co_name" class="form-control" id="validationCustom01"
                                    placeholder="Company Name" value="{{ $editInfo->co_name }}">
                                @error('co_name')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                        </div>
                        <div class="form-row">
                            {{-- <div class="col-md-6 mb-3">
                            <label for="validationCustom01">Branch Name * :</label>
                            <select class="form-control select2" name="branch_id">
                                <option selected disabled value="">--Select--</option>
                                <option value="0">Branch</option>
                                @foreach ($branch as $key => $value)
                                <option <?php if ($editInfo->branch_id == $value->id) {
                                    echo 'selected="selected"';
                                } ?>
                                    value="{{$value->id}}">{{$value->name}}</option>
                                @endforeach
                            </select>
                            @error('branch_id')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div> --}}
                            <div class="col-md-6 mb-3 d-none">
                                <label for="validationCustom01">Customer Group Name :</label>
                                <select name="customergroup_id" class="form-control">
                                    <option value="0">Not Applicable</option>
                                    @foreach ($customerGroup as $value)
                                        <option {{ $editInfo->customergroup_id == $value->id ? 'selected' : '' }}
                                            value="{{ $value->id }}">{{ $value->name }}</option>
                                    @endforeach
                                </select>
                                @error('customergroup_id')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="validationCustom01">Branch Name * :


                                </label>
                                <select class="form-control select2" name="branch_id">
                                    <option selected disabled value="">--Select--</option>

                                   @if(auth()->user()->role_id > 1)
                                    @foreach ($branchs as $key => $value)
                                        <option value="{{ $value->id }}" {{auth()->user()->branch_id == $value->id ? 'selected' :''}}>{{ $value->name }}</option>
                                    @endforeach
                                    @else 

                                  @foreach ($branchs as $key => $value)
                                        <option value="{{ $value->id }}">{{ $value->name }}</option>
                                    @endforeach
                                    @endif
                                </select>
                                @error('name')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02"> E-mail :</label>
                                <input type="text" name="email" class="form-control" id="validationCustom02"
                                    placeholder="E-mail" value="{{ $editInfo->email }}">
                                @error('email')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Phone * :</label>
                                <input type="text" name="phone" class="form-control" id="validationCustom01"
                                    placeholder="Phone" value="{{ $editInfo->phone }}" required>
                                @error('phone')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Image</label>
                                    <div class="file-input-wrapper">
                                        <input type="file" id="voucher-input" name="image"
                                            accept="image/*,.pdf,.doc,.docx" class="@error('image') is-invalid @enderror">
                                        <label for="voucher-input" class="file-input-label">
                                            <i class="fa fa-cloud-upload"></i>
                                            <div>Click to select file</div>
                                            <small>Images, PDF, DOC files supported</small>
                                        </label>
                                        <div class="file-name" id="file-name"></div>
                                    </div>
                                    @error('image')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror

                                    <!-- Image Preview Container -->
                                    <div class="image-preview-container">
                                        <div class="image-preview" id="image-preview">
                                            @if ($editInfo->logo && file_exists(public_path('/backend/logo/' . $editInfo->logo)))
                                                <img id="preview-img"
                                                    src="{{ asset('/backend/logo/' . $editInfo->logo) }}" alt="Preview">
                                            @else
                                                <img id="preview-img" src="" alt="Preview"
                                                    style="display: none;">
                                            @endif
                                            <button type="button" class="image-remove-btn" id="remove-image">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6 mb-3">
                                <label for="validationCustom02">Address* :</label>
                                <input name="address" class="form-control" id="validationCustom02" placeholder="Address"
                                    value="{{ $editInfo->address }}" required>
                                @error('address')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                             <div class="col-md-6 mb-3">
                                <label for="validationCustom02">Customer Note *:</label>
                                <textarea name="customeNote" class="form-control" id="validationCustom02" placeholder="customerNote"
                                    value="" >{{$editInfo->customeNote }}</textarea>
                                @error('customerNote')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom07">Bin :</label>
                                <input name="bin" class="form-control" id="validationCustom07" placeholder="Bin"
                                    value="{{ $editInfo->bin }}">
                                @error('bin')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <button class="btn btn-info" type="submit"><i class="fa fa-save"></i>&nbsp;Update</button>
                    </form>


                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>

    <script>
        $(document).ready(function() {
            @if ($editInfo->logo)
                @if (file_exists(public_path('/backend/logo/' . $editInfo->logo)))
                    // Show existing image info
                    $('#file-name').html(`
                <div class="existing-file-info">
                    <i class="fa fa-check-circle"></i>
                    Current file: {{ $editInfo->logo }}
                </div>
            `);
                    $('#image-preview').show();
                @else
                    // File doesn't exist, show error
                    $('#file-name').html(`
                <div class="existing-file-info" style="background: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                    <i class="fa fa-exclamation-triangle"></i>
                    Previous file not found: {{ $editInfo->logo }}
                </div>
            `);
                @endif
            @endif

            $('#voucher-input').on('change', function(e) {
                const file = e.target.files[0];
                const fileName = $('#file-name');
                const imagePreview = $('#image-preview');
                const previewImg = $('#preview-img');

                if (file) {
                    // Show file name
                    fileName.text(file.name);

                    // Check if file is an image
                    if (file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            previewImg.attr('src', e.target.result);
                            previewImg.show();
                            imagePreview.show();
                        }
                        reader.readAsDataURL(file);
                    } else {
                        // For non-image files, show file info
                        imagePreview.hide();
                        fileName.html(
                            `<i class="fa fa-file"></i> ${file.name} (${(file.size / 1024).toFixed(2)} KB)`
                            );
                    }

                    // Update label text
                    $('.file-input-label').html(`
                <i class="fa fa-check-circle" style="color: #28a745;"></i>
                <div>File selected successfully</div>
                <small>Click to change file</small>
            `);
                }
            });

            // Remove image functionality
            $('#remove-image').on('click', function() {
                $('#voucher-input').val('');
                $('#image-preview').hide();
                $('#preview-img').hide();
                $('#file-name').text('');
                $('.file-input-label').html(`
            <i class="fa fa-cloud-upload"></i>
            <div>Click to select file</div>
            <small>Images, PDF, DOC files supported</small>
        `);
            });

            // Drag and drop functionality
            $('.file-input-label').on('dragover', function(e) {
                e.preventDefault();
                $(this).addClass('drag-over');
            });

            $('.file-input-label').on('dragleave', function(e) {
                e.preventDefault();
                $(this).removeClass('drag-over');
            });

            $('.file-input-label').on('drop', function(e) {
                e.preventDefault();
                $(this).removeClass('drag-over');

                const files = e.originalEvent.dataTransfer.files;
                if (files.length > 0) {
                    $('#voucher-input')[0].files = files;
                    $('#voucher-input').trigger('change');
                }
            });

        })
    </script>
@endsection
