@extends('backend.layouts.master')

@section('title')
  {{ __('Inventory') . ' - ' . $title}} 
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('fabric') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{route('home')}}">{{ __('Dashboard') }}</a>
            </li>
            @if(helper::roleAccess('inventorySetup.fabric.index'))
              <li class="breadcrumb-item">
                <a href="{{ route('inventorySetup.fabric.index') }}">{{ __('fabric List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ __('Add New fabric') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ __('Add New fabric') }}</h3>
          <div class="card-tools">
            @if(helper::roleAccess('inventorySetup.fabric.index'))
              <a class="btn btn-default" href="{{ route('inventorySetup.fabric.index') }}">
                <i class="fa fa-list"></i>
                <span>{{ __('fabric List') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('inventorySetup.fabric.store') }}" novalidate>
            @csrf
            <div class="form-row">
              <div class="col-md-6 mb-3">
                <label for="validationCustom01">{{ __('Name * :') }}</label>
                <input type="text" name="name" class="form-control form-control-sm" id="validationCustom01" placeholder="Name" value="{{ old('name') }}">
                @error('name')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>
              <div class="col-md-6 mb-3">
                <label for="validationCustom01">{{ __('Status * :') }}</label>
                <select class="form-control select2" name="status">
                  <option value="Pending">{{ __('--Select--') }}</option>
                  <option value="Display">{{ __('Display') }}</option>
                  <option value="Hidden">{{ __('Hidden') }}</option>
                </select>
                @error('status')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

                <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Branch Name * :

                                  
                                </label>
                                <select class="form-control select2" name="branch_id">
                                    <option selected disabled value="">--Select--</option>
                                   @if(auth()->user()->role_id > 1)
                                    @foreach ($branchs as $key => $value)
                                        <option value="{{ $value->id }}" {{auth()->user()->branch_id == $value->id ? 'selected' :''}}>{{ $value->name }}</option>
                                    @endforeach
                                    @else 

                                  @foreach ($branchs as $key => $value)
                                        <option value="{{ $value->id }}">{{ $value->name }}</option>
                                    @endforeach
                                    @endif
                                </select>
                                @error('branch_id')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
        
            </div>       
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp;{{ __('Save') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection