@extends('backend.layouts.master')

@section('title')
  {{ __('Inventory') . ' - ' . $title }}
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Inventory') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if (helper::roleAccess('inventorySetup.genre.index'))
              <li class="breadcrumb-item">
                <a href="{{ route('inventorySetup.genre.index') }}">{{ __('Genre List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ __('Add New Genre') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ __('Add New Genre') }}</h3>
          <div class="card-tools">
            @if (helper::roleAccess('inventorySetup.genre.index'))
              <a class="btn btn-default" href="{{ route('inventorySetup.genre.index') }}">
                <i class="fa fa-list"></i>
                <span>{{ __('Genre List') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('inventorySetup.genre.store') }}" novalidate>
            @csrf
            <div class="form-row">
              <div class="col-md-6 mb-3">
                <label for="validationCustom01">{{ __('Name * :') }}</label>
                <input type="text" name="name" class="form-control" id="validationCustom01" placeholder="Name" value="{{ old('name') }}" />
                  @error('name')
                    <span class=" error text-red text-bold">{{ $message }}</span>
                  @enderror
              </div>
              <div class="col-md-6 mb-3">
                <label for="validationCustom01">{{ __('Name * :') }}</label>
                <select class="form-control select2" name="parent_id">
                  <option selected  value="0">{{ __('Root') }}</option>
                  @foreach ($genre as $key => $value)
                    <option value="{{ $value->id }}">{{ $value->name }}</option>
                  @endforeach
                </select>
                @error('parent_id')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>
            </div>
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp;{{ __('Save') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection
