@extends('backend.layouts.master')
@section('title')
    inventory - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
 
@endsection

@section('navbar-content')
  <div class="content-header">
        <div class="container-fluid" style="padding-left:20px">
            <div class="row mb-2">
                <div class="col-sm-6 col-md-3" style="display: flex;gap:10px;border:1px solid;font-wieght:bold">
                    <h1 class="m-0" style=" font-weight: bold;   border-right: 1px solid;
    padding: 1px;
">
                        Total Due </h1>
                          <h1 class="m-0" style="font-weight: bold;">
                        {{$supplierDue}} &#2547;</h1>
                </div>
                <div class="col-md-3"></div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                      
                        <li class="breadcrumb-item active"><span>Supplier Due List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
    <div class="row w-100 align-items-center">

        <!-- Left Column -->
        <div class="col-md-6 d-flex align-items-center">
            <h3 class="card-title mb-0">Supplier List</h3>
        </div>

        <!-- Right Column -->
        <div class="col-md-6 text-md-right mt-2 mt-md-0">

        
         

        </div>

    </div>
</div>


                <div class="card-body">
                    <form method="GET" action="{{ route('inventorySetup.supplier.due') }}" class="mb-4">
                        <div class="row">
                           

                            <div class="col-md-3">
    <select name="supplier_id" class="form-control select2" id="Supplier">
        <option value="all" {{ request('supplier_id') == 'all' ? 'selected' : '' }}>All</option>

        @foreach ($suppliers as $supplier)
            <option value="{{ $supplier->id }}"
                {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                {{ $supplier->name }} ({{ $supplier->phone }})
            </option>
        @endforeach
    </select>
</div>


                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Search</button>
                                <a href="{{ route('inventorySetup.supplier.due') }}" class="btn btn-secondary ml-2">Reset</a>
                            </div>
                        </div>
                    </form>

                     <div class="table-responsive my-2">
                          <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Supplier Name</th>
                                    <th>Image</th>
                                    <th>Address</th>
                                    <th>Supplier Due (&#2547;)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($supplierDueList as $data)
                     @php
        $chartOfAccount = \App\Models\ChartOfAccount::where([
            'accountable_id'   => $data->id,
            'accountable_type' => \App\Models\Supplier::class,
        ])->first();
    @endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $data->name }} ({{ $data->phone }})</td>
                                        <td>
                                                 @if (!empty($data->image))
                                        <img src="{{ asset('/backend/logo/' . $data->image) }}"
                                            style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
                                            alt="Supplier Image">
                                    @else
                                        <img src="{{ asset('/backend/logo/default.png') }}"
                                            style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
                                            alt="Default Supplier Image">
                                    @endif
                                            {{-- <img src="{{ asset('/backend/logo/' . $data->image) }}"
                                                alt="Preview" width="50" height="50"
                                                style="object-fit: cover; border-radius: 5px;"> --}}
                                        </td>
                                        <td>{{ $data->address }}</td>
                                        <td>{{ number_format($data->due_amount) }}</td>
                                        <td>
                                            <a href="{{route('inventorySetup.supplier.show',$data->id)}}" class="btn btn-sm btn-info">View</a>
                                        </td>
                                    </tr>
                                @endforeach
                                @if($supplierDueList->isEmpty())
                                    <tr>
                                        <td colspan="6" class="text-center">No data found for selected date range.</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
