@extends('backend.layouts.master')

@section('title')
  {{ __('Order') . ' - ' . $title }}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
    @media print {
      body {
        background: white !important;
      }
    }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ !Auth::guard('web')->user() ? route('buyer.dashboard') : route('home') }}">{{ __('Dashboard') }}</a>
            </li>
              @if (helper::roleAccess('proforma.invoice.list'))
                <li class="breadcrumb-item">
                  <a href="{{ route('proforma.invoice.list') }}">{{ __('PI List') }}</a>
                </li>
              @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header no-print">
          <h3 class="card-title">{{ $title }}</h3>
          <div class="card-tools">
            <a onclick="window.print()" target="_blank" class="btn btn-default float-right">
              <i class="fas fa-print"></i>
              <span>{{ __('Print') }}</span>
            </a>
          </div>
        </div>
        <div class="card-body">
          {{-- <div class="row no-print">
            <div class="col-12">
              <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2">
                <i class="fas fa-print"></i>
                <span>{{ __('Print') }}</span>
              </a>
            </div>
          </div> --}}
          <div class="invoice p-3 mb-3">
            <div class="row invoice-info">
              <div class="col-sm-4 ">
                @if (isset($companyInfo->invoice_logo))
                  <img width="200px" src="{{ asset('/backend/invoicelogo/' . $companyInfo->invoice_logo) }}" style="" alt="" />
                @endif
              </div><!-- /.col -->
              <div class="col-sm-4 invoice-col" style="text-align: center;">
                <b style="font-size : 20px">{{ $companyInfo->company_name ?? 'N/A' }}</b>
                <address>
                  <span>{{ __('Phone :') }}</span> <strong>{{ $companyInfo->phone ?? 'N/A' }}</strong><br>
                  <span>{{ __('Address :') }}</span> <strong><em>{{ $companyInfo->address ?? 'N/A' }}</em></strong><br>
                  <span>{{ __('Email:') }}</span> <strong>{{ $companyInfo->email ?? 'N/A' }}</strong>
                </address>
              </div><!-- /.col -->          
              <div class="col-sm-4 invoice-col" style="text-align:right">
                <b style="text-decoration: underline" >{{ $title }}</b><br>
                <b> {{ __('PI No. :') }} </b> <span style="text-decoration: underline;" >{{ $pi->pi_number ?? 'N/A' }}</span> <br>
                <b> {{ __('Date :') }} </b> <span style="text-decoration: underline" >{{ $pi->pi_date ?? 'N/A' }}</span> <br>
                <b>{{ __('VAT No. :') }} </b> <span style="text-decoration: underline" >{{ $pi->vat_number ?? 'N/A' }}</span><br>
              </div><!-- /.col -->
            </div><!-- /.row -->
            <hr>
            <div class="row">
              <div class="col">
                <p>
                  <strong>{{ __('Invoice :') }}</strong>
                  <span style="text-decoration: underline;" >{{ $pi->order->order_code }}</span>
                </p>
              </div>
              <div class="col">
                <p class="text-center">
                  <strong>{{ __('Style No. :') }}</strong>
                  <span style="text-decoration: underline;" >{{ $pi->order->style_no }}</span>
                </p>
              </div>
              <div class="col">
                <p class="text-right">
                  <strong>{{ __('PO Number. :') }}</strong>
                  <span style="text-decoration: underline;" >{{ $pi->order->po_number }}</span>
                </p>
              </div>
              <div class="col-12 text-center my-4">
                <h4 class="text-center">
                  <strong class="bg-info px-4">{{ strtoupper($title) }}</strong>
                </h4>
              </div>
              <div class="col-12">
                <p>
                  <strong>{{ __('Buyer : ') }}</strong>
                  <span style="text-decoration: underline;" >{{ ($invoice->buyer->name ?? 'N/A') . ' - ' . ($invoice->buyer->company_name ?? 'N/A') . ' - (' . ($invoice->buyer->phone ?? 'N/A') . ')' }}</span>
                </p>
              </div>
            </div>
            <div class="row">
              <div class="col-12 table-responsive">
                <table class="table table-striped table-bordered">
                  <thead>
                    <tr>
                      <th width="80px">{{ __('SL') }}</th>
                      <th width="175px">{{ __('HS Code') }}</th>
                      <th>{{ __('Item Description') }}</th>
                      <th class="text-center" width="120px" >{{ __('Qty') }}</th>
                      <th class="text-center" width="120px" >{{ __('Unit Price') }}</th>
                      <th style="text-align:right" width="120px">{{ __('Total') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($invoice->details as $key => $item)
                      <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>
                          @if ($item->hs_code != null)
                            <span>{{ $item->hs_code }}</span>
                          @else
                            <input type="text" name="hs_code[]" class="form-control form-control-sm" id="hsCode" placeholder="HS Code" required />
                          @endif
                        </td>
                        <td>
                          <div class="row" >
                            <div class="ml-1" style="width: 45px !important;" >
                              <img src="{{ $item->thumbnail }}" class="" alt="" width="40px" height="40px" />
                            </div>
                            <div class="col" >
                              <strong>{{ $item->goods_name ?? 'N/A' }}</strong><br>
                              <small>{{ $item->category ?? 'N/A' }}</small>
                            </div>
                          </div>
                        </td>
                        <td class="text-center">{{ $item->quantity ?? 'N/A' }}</td>
                        <td class="text-right">
                          @if (!Auth::guard('web')->user())
                            <span>{{ number_format($item->rate, 2) . '/-' }}</span>
                          @else
                            @if ($item->rate == 0)
                              <input type="number" class="form-control form-control-sm" value="{{ $item->rate }}" id="rate{{ $key }}" placeholder="Unit Price" />
                            @else
                              <span>{{ number_format($item->rate, 2) . '/-' }}</span>
                            @endif
                          @endif
                        </td>
                        <td class="text-right">{{ number_format($item->price, 2) . '/-' }}</td>
                      </tr>
                    @endforeach
                  </tbody>
                  <tfoot>
                    <tr>
                      <th colspan="3" style="text-align: right">{{ __('TOTAL =') }}</th>
                      <td class="text-center">{{ $invoice->details->sum('quantity') }}</td>
                      <td></td>
                      <th class="text-right">{{ number_format($pi->order->amount, 2) . '/-' }}</th>
                    </tr>
                    <tr>
                      <th width="90px">{{ __('In words : ') }}</th>
                      <th colspan="5">{{ ucfirst(Terbilang::make($pi->order->amount)) . ' taka only.' ?? 'N/A' }}</th>
                    </tr>
                    <tr>
                      <td colspan="6"><b>{{ __('Order Note :') }}</b> {!! $pi->order->note ?? 'N/A' !!}</td>
                    </tr>
                  </tfoot>
                </table>
              </div>
              @if ($pi->note != null)
                <div class="col-md-12">{!! $pi->note !!}</div>
              @endif
              <div class="col-4 float-left">
                <br>
                <br>
                <p>
                  <span>{{ __('Received by: ____________________') }}</span>
                  <br />
                  <span>{{ __('Date: ____________________') }}</span>
                </p>
              </div>
              <div class="col-4 text-center"></div>
              <div class="col-4 text-right float-right">
                <br>
                <br>
                  <p>
                    <span>{{ __('Authorized by: ____________________') }}</span>
                    <br />
                    <span>{{ __('Date: ____________________') }}</span>
                  </p>
              </div>
              <hr>
              <div class="col-md-12 bg-success" style="text-align: center;">
                {{ __('Thank you for choosing Our products. We believe you will be satisfied by our services.') }}
              </div><!-- /.col -->
            </div>
          </div>
        </div>
        <div class="card-footer"></div>
      </div><!-- /.col-->
    </div>
  </section>
@endsection

@section('scripts')
@endsection
