@extends('backend.layouts.master')
@section('title')
    Quick Sales List - {{ '' }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    {{-- <h1 class="m-0">
                        Inventory </h1> --}}
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('sale.sale.index'))
                            <li class="breadcrumb-item"><a href="{{ route('sale.sale.index') }}">Sale</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span>Sale List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title"> Quick Sale List</h3>
                    <div class="card-tools">
                        @if (helper::roleAccess('sale.sale.create'))
                            <a class="btn btn-default" href="{{ route('quicksales.create') }}"><i
                                    class="fas fa-plus"></i>Add
                                New</a>
                        @endif
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer</th>
                                    <th>Date</th>
                                    <th>Phone</th>
                                    <th>Grand Total</th>
                                    <th>Discount</th>
                                    <th>Shipping Cost</th>
                                    <th>Paid Amount</th>
                                    <th>Total Due</th>
                                    <th>Payment Status</th>
                                    <th>Delivery Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            {{-- @dd($quickSales) --}}
                            <tbody>
                                @foreach ($quickSales as $sale)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{  'N/A' }}</td>
                                        <td>{{ $sale->date }}</td>
                                        <td>{{  'N/A' }}</td>
                                        <td>{{ number_format($sale->total_amount, 0) }}</td>
                                        <td>{{ number_format($sale->discount, 0) }}</td>
                                        <td>{{ number_format($sale->shipping_charge, 0) }}</td>
                                        <td>{{ number_format($sale->received_amount, 0) }}</td>
                                        <td>{{ number_format($sale->due_balance, 0) }}</td>
                                        <td>{{ $sale->payment_status }}</td>
                                        <td>{{ $sale->delivery_status }}</td>
                                        <td class=" d-flex">
                                            <a href="{{ route('quick.sales.show', $sale->id) }}"
                                                class="btn btn-info ">Show</a>
                                            <a href="{{ route('quick.sales.edit', $sale->id) }}"
                                                class="btn btn-primary  ml-2">Edit</a>
                                            <form action="{{ route('quick.sales.delete', $sale->id) }}" method="POST"
                                                class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger  ml-2">
                                                    DELETE
                                                </button>
                                            </form>
                                        </td>

                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer</th>
                                    <th>Date</th>
                                    <th>Phone</th>
                                    <th>Grand Total</th>
                                    <th>Discount</th>
                                    <th>Shipping Cost</th>
                                    <th>Paid Amount</th>
                                    <th>Total Due</th>
                                    <th>Payment Status</th>
                                    <th>Delivery Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
@endsection
@section('scripts')
@endsection
