@extends('backend.layouts.master')
@section('title')
    Report - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Report</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('project.project.index'))
                            <li class="breadcrumb-item"><a href="{{ route('project.project.index') }}">Project</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span>Project List</span></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Accesories Stock Summary</h3>
                    <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2 no-print">
                        <i class="fas fa-print"></i> Print
                    </a>

                    <form action="{{ route('inventorySetup.currentStock.index') }}" method="post">
                        @csrf

                    </form>
                </div>

                <div class="card-body">
                    <div class="invoice p-3 mb-3">
                        <div class="row">
                            <div class="col-12 table-responsive">
                                @php
                                    $totalQty = 0;
                                    $i = 1;
                                @endphp
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Product</th>
                                            <th>Unit</th>
                                            <th>Quantity</th>
                                            <th>In KG</th>
                                            <th>Out KG</th>
                                            <th>Available Stock (KG)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($currentStock as $item)
                                            @php
                                                // Get total in quantity and total in kg for the given product_id
                                                $stockindetails = App\Models\Stockindetails::where(
                                                    'aceesories_id',
                                                    $item->product_id,
                                                );
                                                $total_in_kg = $stockindetails->sum('kg');
                                                $total_in_qty = $stockindetails->sum('in_quantity');

                                                // Calculate the rate per quantity (per kg)
                                                $rate_per_kg = $total_in_kg / $total_in_qty; // This gives you the kg per quantity

                                                // Get total out quantity (sum of out quantity for the given product_id)
                                                $stockoutdetails = App\Models\Stockoutdetails::where(
                                                    'aceesories_id',
                                                    $item->product_id,
                                                );
                                                $total_out_qty = $stockoutdetails->sum('in_quantity');

                                                // Calculate total out quantity in kg
                                                $total_out_kg = $total_out_qty * $rate_per_kg;

                                            @endphp
                                            @php $totalQty += $item->quantity; @endphp
                                            <tr>
                                                <td>{{ $i++ }}</td>
                                                <td>{{ $item->accessories->name ?? null }}</td>
                                                <td>{{ $item->accessories->unit ?? null }}</td>
                                                <td>{{ $item->quantity }}</td>
                                                <td>{{ $total_in_kg }}</td>
                                                <td>{{ $total_out_kg }}</td>
                                                <th>{{ $total_in_kg - $total_out_kg }}</th>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3" style="text-align: right">Total</th>
                                            <th>{{ $totalQty }}</th>
                                            <th></th>
                                            <th></th>
                                            <th></th>

                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            <div class="col-md-4">
                                <br><br>
                                <p>
                                    Prepared By: _____________<br />
                                    Date: ____________________
                                </p>
                            </div>

                            <div class="col-md-6 text-center"></div>

                            <div class="col-md-2">
                                <br><br>
                                <p>
                                    Approved By: ________________<br />
                                    Date: __________________
                                </p>
                            </div>

                            <div class="col-md-12 bg-success text-white text-center py-2 mt-3">
                                Thank you for choosing {{ $companyInfo->company_name ?? 'N/A' }} Company products.
                                We believe you will be satisfied by our services.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#categorysubmit').on('change', function() {
                $(this).closest('form').submit();
            });
        });
    </script>
@endsection
