@extends('backend.layouts.master')

@section('title', 'Edit Stock In')

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Edit Stock In</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('stockin.list') }}">Stock In</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('admin-content')
<div class="row justify-content-center">
    <div class="col-md-11">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Edit Stock In</h3>
            </div>

            <form action="{{ route('stockin.update', $stockIn->id) }}" method="POST" id="edit-stockin-form">
                @csrf
                @method('PUT') <!-- Use PUT method for updates -->
                <div class="card-body">
                    <div class="row">
                        {{-- Accessory Name Field --}}
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="accessory_name">Accessory Name</label>
                                <select name="accessory_name" id="accessory_name"
                                    class="form-control @error('accessory_name') is-invalid @enderror" >
                                    <option value="">Select Accessory</option>
                                    @foreach (App\Models\Accesories::all() as $accessory)
                                        <option value="{{ $accessory->name }}" data-id="{{ $accessory->id }} "
                                            data-unit="{{ $accessory->unit }}"
                                            {{ $stockIn->accessory_id == $accessory->id ? 'selected' : '' }}>
                                            {{ $accessory->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('accessory_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        {{-- Unit Field --}}
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="unit">Unit</label>
                                <input type="text" name="unit" id="unit"
                                    class="form-control @error('unit') is-invalid @enderror"
                                    value="{{ $stockIn->accessory->unit ?? old('unit') }}" placeholder="Unit will be auto-filled"
                                    readonly required>
                                @error('unit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        {{-- Append Button (with Plus Icon) --}}
                        <div class="col-md-2 d-flex align-items-end mb-3">
                            <button type="button" id="append-fields" class="btn btn-secondary w-100 p-2">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>

                    {{-- Dynamic Fields Container --}}
                    <div id="additional-fields-container" class="mt-3">
                        @if ($stockIn)
                           @foreach ($stockIn->stock_in_details as $details)
                           <div class="row dynamic-row" id="row-{{ $details->id }}">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea name="description[]" class="form-control" rows="3"
                                            placeholder="Enter description" >{{ $details->description }}</textarea>
                                    </div>
                                </div>
                                <input type="hidden" name="accessory_id[]" value="{{ $details->aceesories_id }}">
                                <input type="hidden" name="detail_id[]" value="{{ $details->id }}">

                                <input type="hidden" name="old_quantity[]" value="{{ $details->in_quantity }}">

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="in_quantity">In Quantity</label>
                                        <input type="number" name="in_quantity[]" class="form-control"
                                            value="{{  $details->in_quantity }}" placeholder="Enter quantity" required>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="price">Price</label>
                                        <input type="number" name="price[]" class="form-control" value="{{ number_format($details->price, 2) }}" step="0.01">
                                    </div>
                                </div>


                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="accessory_id">Accessory Name</label>
                                        <input type="text" class="form-control"
                                            value="{{ $details->accessories->name ?? '' }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="unit">Unit</label>
                                        <input type="text" class="form-control"
                                            value="{{ $details->accessories->unit ?? '' }}" readonly>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="kg">KG</label>
                                        <input type="number" name="kg[]" class="form-control" value="{{ $details->kg }}" step="0.01">
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="total_price">Total Price</label>
                                        <input type="number" name="total_price[]" class="form-control" value="{{ $details->total_price }}" readonly>
                                    </div>
                                </div>


                                <div class="col-md-2 align-self-end mb-3">
                                    <button type="button" class="btn btn-danger remove-row" data-row-id="row-{{ $details->id }}">
                                        <i class="fa fa-trash"></i> Remove
                                    </button>
                                </div>
                            </div>
                           @endforeach
                        @endif
                    </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="{{ route('stockin.list') }}" class="btn btn-secondary">Back to List</a>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
    // Update unit field when accessory is changed
    $('#accessory_name').on('change', function () {
        var unit = $(this).find(':selected').data('unit');
        $('#unit').val(unit || '');
    });

    // Auto-calculate total price on quantity or price input
// Auto-calculate total price based on KG or Quantity
$(document).on('input', 'input[name="price[]"], input[name="in_quantity[]"], input[name="kg[]"]', function () {
    var $row = $(this).closest('.dynamic-row');
    var price = parseFloat($row.find('input[name="price[]"]').val()) || 0;
    var quantity = parseFloat($row.find('input[name="in_quantity[]"]').val());
    var kg = parseFloat($row.find('input[name="kg[]"]').val());

    var total = 0;

    if (!isNaN(kg) && kg > 0) {
       
        total = kg * price;
    } else if (!isNaN(quantity) && quantity > 0) {
    
        total = quantity * price;
    }

    $row.find('input[name="total_price[]"]').val(total.toFixed(2));
});

    // Append new dynamic row
    let rowCount = 1;
    $('#append-fields').on('click', function () {
        var accessoryName = $('#accessory_name').val();
        var accessoryId = $('#accessory_name').find(':selected').data('id');
        var unit = $('#unit').val();

        if (accessoryName && unit) {
            rowCount++;
            var newFields = `
                <div class="row dynamic-row" id="row-${rowCount}">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea name="description[]" class="form-control" rows="3" placeholder="Enter description"></textarea>
                        </div>
                    </div>
                    <input type="hidden" name="accessory_id[]" value="${accessoryId}">
                    <input type="hidden" name="detail_id[]" value="0">
                    <input type="hidden" name="old_quantity[]" value="0">

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="in_quantity">In Quantity</label>
                            <input type="number" name="in_quantity[]" class="form-control" placeholder="Enter quantity" required>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="price">Price</label>
                            <input type="number" name="price[]" class="form-control" placeholder="Enter price" step="0.01" required>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="accessory_id">Accessory Name</label>
                            <input type="text" class="form-control" value="${accessoryName}" readonly>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="unit">Unit</label>
                            <input type="text" class="form-control" value="${unit}" readonly>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="kg">KG</label>
                            <input type="number" name="kg[]" class="form-control" placeholder="Enter kg" step="0.01">
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="total_price">Total Price</label>
                            <input type="number" name="total_price[]" class="form-control" value="0" readonly>
                        </div>
                    </div>

                    <div class="col-md-2 align-self-end mb-3">
                        <button type="button" class="btn btn-danger remove-row" data-row-id="row-${rowCount}">
                            <i class="fa fa-trash"></i> Remove
                        </button>
                    </div>
                </div>
            `;
            $('#additional-fields-container').append(newFields);
        } else {
            alert('Please select an accessory and unit before appending fields.');
        }
    });

    // Remove row
    $(document).on('click', '.remove-row', function () {
        var rowId = $(this).data('row-id');
        $('#' + rowId).remove();
    });

    // Submit form and format price values
    $('#edit-stockin-form').submit(function () {
        // Loop through each price input and round to 2 decimal places before submission
        $('input[name="price[]"]').each(function () {
            var price = parseFloat($(this).val());
            if (!isNaN(price)) {
                $(this).val(price.toFixed(2)); // Format the price to 2 decimal places
            }
        });
    });
});

</script>

@push('scripts')
@endpush
