@extends('backend.layouts.master')
@section('title')
Swing Sale - {{ $title }}
@endsection

@section('styles')
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
@endsection

@section('navbar-content')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Swing  Sale </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                        @if (helper::roleAccess('sale.swing.index'))
                            <li class="breadcrumb-item"><a href="{{ route('sale.swing.index') }}">Sale</a></li>
                        @endif
                        <li class="breadcrumb-item active"><span>Swing Sale List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('admin-content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Swing Sale Invoice</h3>
                </div>
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="{{ route('sale.swing.store') }}" novalidate>
                        @csrf
                        <div class="form-row">
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Invoice Number :</label>
                                <input class="bg-green form-control" readonly=""
                                    style="padding: 5px; font-weight : bold; width: 100%" value="{{ $invoice_no }} "
                                    for="validationCustom01">
                                <input type="hidden" name="invoice_no" class="form-control" id=""
                                    value="{{ $invoice_no }}">
                            </div>
                            {{-- <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Po Number :</label>
                            <input type="text" name="po_invoice" class="form-control">
                        </div> --}}
                            {{-- <div class="col-md-2 mb-3">
                            <label>Po Date:</label>
                            <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                                <input type="text" name="po_date" data-toggle="datetimepicker"
                                    value="{{ date('YYYY-mm-dd') }}" class="form-control datetimepicker-input"
                                    data-target="#reservationdate1" />
                                <div class="input-group-append" data-target="#reservationdate1"
                                    data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                            @error('date')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div> --}}
                            <div class="col-md-2 mb-3">
                                <label>Date:</label>
                                <div class="input-group date" id="reservationdate" data-target-input="nearest">
                                    <input type="text" name="date" data-toggle="datetimepicker"
                                        value="{{ date('YYYY-mm-dd') }}" class="form-control datetimepicker-input"
                                        data-target="#reservationdate" />
                                    <div class="input-group-append" data-target="#reservationdate"
                                        data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                @error('date')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Branch * :</label>
                                <select class="form-control select2" id="branch_id" name="branch_id">
                                 
                                    @foreach ($branch as $key => $value)
                                    @if($value->id ==1)
                                        <option value="{{ $value->id }}">
                                            {{ $value->branchCode . ' - ' . $value->name }}
                                        </option>
                                        @endif
                                    @endforeach
                                </select>
                                @error('branch_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- <div class="col-md-2 mb-3">
                                <label for="validationCustom02">Sub-Warehouse * :</label>
                                <select class="form-control select2" id="sub_warehouse_id" name="sub_warehouse_id">
                                    <option selected disabled value="">--Select Sub-Warehouse--</option>
                                    @foreach ($wearhouses as $key => $value)
                                        <option value="{{ $value->id }}">
                                            {{ $value->branchCode . ' - ' . $value->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('sub_warehouse_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div> --}}


                            {{-- <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Customer * :</label>
                            <select class="form-control select2" name="customer_id" id="customer_id">
                                <option selected disabled value="">--Select Customer--</option>
                                @foreach ($customer as $key => $value)
                                <option value="{{ $value->id }}">
                                    {{ $value->customerCode . ' - ' . $value->co_name }}
                                </option>
                                @endforeach
                            </select>
                            @error('customer_id')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div> --}}

                            <div class="col-md-2 mb-3">
                                <label for="ledger_id">Ledger * :
                                    <button type="button" class="btn btn-sm btn-primary ml-2" data-toggle="modal"
                                        data-target="#addCustomerModel">
                                        +
                                    </button>
                                </label>
                                <select class="form-control select2" name="ledger_id" id="ledger_id">
                                    <option selected disabled value="">--Select Ledger--</option>
                                    <x-account :setAccounts="$ledgers" />
                                </select>
                                @error('ledger_id')
                                    <span class=" error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            {{-- <div class="col-md-2 mb-3">
                            <label for="validationCustom01">Balance * :</label>
                            <input type="text" id="customer_currentBalance" class="form-control" readonly>
                        </div> --}}
                            <div class="col-md-2 mb-3">
                                <label for="validationCustom01">Payment Type * :</label>
                                <br>
                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                    <label class="btn bg-olive">
                                        <input type="radio" name="payment_type" value="Due"
                                            onchange="getCustomerBalance('Due')" checked id="option3" autocomplete="off">
                                        Due
                                    </label>
                                    {{-- <label class="btn bg-olive active">
                                    <input type="radio" name="payment_type" value="Cash"
                                        onchange="getCustomerBalance('Cash')" id="option1" autocomplete="off"> Cash
                                </label> --}}
                                    {{-- <label class="btn bg-olive">
                                    <input type="radio" name="payment_type" value="Deposit"
                                        onchange="getCustomerBalance('Deposit')" id="option2" autocomplete="off">
                                    Deposit
                                </label> --}}

                                </div>
                                <input type="hidden" id="paymentType">
                                <input type="hidden" id="expireData">
                            </div>
                            <table class=" table-responsive table table-bordered">
                                <tr>
                                    <td>
                                        <div class="col-md-9 float-left ">
                                            Sales Item
                                        </div>
                                        <div class="col-md-3 float-right">
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px!important;">
                                        <div class="col-md-12">
                                            <div class="col-md-12 float-left">
                                                <div class="panel panel-default">
                                                    <div class="panel-body">

                                                        <table class="table table-bordered table-hover tableAddItem"
                                                            id="show_item">
                                                            <thead>
                                                                <tr>
                                                                   
                                                                    <th nowrap style="width:15%" align="center"
                                                                        id="">
                                                                        <strong>Product <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    {{-- <th nowrap style="width:11%" align="center">
                                                                        <strong>Team <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th nowrap style="width:11%" align="center">
                                                                        <strong>Fabrics <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th> --}}
                                                                    <th nowrap style="width:11%" align="center">
                                                                        <strong>Quantity <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    {{-- <th nowrap style="width:11%" align="center">
                                                                    <strong>Vat <span style="color:red;">
                                                                            *</span></strong>
                                                                </th> --}}
                                                                    <th nowrap style="width:12%" align="center">
                                                                        <strong>Unit
                                                                            Price(BDT) <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th nowrap style="width:13%" align="center">
                                                                        <strong>Total Price(BDT) <span style="color:red;">
                                                                                *</span></strong>
                                                                    </th>
                                                                    <th align="center" style="width:5%">
                                                                        <strong>Action</strong>
                                                                    </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    {{-- Product Category --}}
                                                                   

                                                                    {{-- Product --}}
                                                                    <td id="product_td">
                                                                          <select class="select2 form-control proName" id="productID"
                                                                            data-placeholder="Search Product" onchange="getUnitPrice(this.value)">
                                                                            <option value="">---Select Product---</option>
                                                                            @foreach ($products as $product)
                                                                                <option value="{{ $product->id }}" proName="{{ $product->name }}">
                                                                                    {{ $product->name }}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>
                                                                        <span class="text-success purchaseprice"></span>
                                                                    </td>
                                                                    {{-- <td>
                                                                        <input type="text" class="form-control team"
                                                                            id="team">
                                                                    </td> --}}
                                                                    {{-- Fabrics --}}
                                                                    {{-- <td>
                                                                        <select class="select2 form-control purchasetype"

                                                                            onchange="getUnitPrice(this.value)">
                                                                            <option selected disabled value="">--Select Fabrics--</option>
                                                                            @foreach ($fabricType as $key => $value)
                                                                            <option value="{{ $key }}">{{ $value }}</option>
                                                                            @endforeach
                                                                        </select>


                                                                        <span
                                                                            class="text-success purchasetypeerror"></span>
                                                                    </td> --}}


                                                                    {{-- Quantity --}}
                                                                    <td>
                                                                        {{-- <input type="text" readonly
                                                                            class="form-control" style="height: 20px;"
                                                                            id="currentStock" placeholder="0"> --}}
                                                                        <input type="text" class="form-control qty"
                                                                            id="qty" onkeyup="qtyPriceCal();"
                                                                            placeholder="0">
                                                                    </td>

                                                                    {{-- <td>
                                                                        <input type="number" readonly
                                                                            class="form-control" id="gas_qty"
                                                                            min="0" value="0"
                                                                            placeholder="0">
                                                                    </td> --}}

                                                                    {{-- <td>
                                                                        <input type="text"
                                                                            class="form-control text-right vat"
                                                                            id="vat" onkeyup="qtyPriceCal();"
                                                                            placeholder="0.00">
                                                                    </td> --}}

                                                                    {{-- Unit Price --}}
                                                                    <td>
                                                                        <input type="text"
                                                                            class="form-control text-right  unitprice"
                                                                            id="unitpice" onkeyup="qtyPriceCal();"
                                                                            placeholder="0.00">
                                                                    </td>

                                                                    {{-- Total Price --}}
                                                                    <td>
                                                                        <input type="text"
                                                                            class="form-control text-right ttlamount total"
                                                                            id="total" placeholder="0.00"
                                                                            readonly="readonly">
                                                                    </td>

                                                                    <td>
                                                                        <a id="add_item"
                                                                            class="btn btn-info form-control"
                                                                            href="javascript:;" title="Add Item">
                                                                            <i class="fa fa-plus"></i>
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <td align="right"><strong>Sub-Total(BDT)</strong></td>

                                                                    <td
                                                                        align="
                                                                                right">
                                                                        <strong class="ttlqty"></strong>
                                                                    </td>
                                                                    <td align="right"><strong
                                                                            class="ttlunitprice"></strong>
                                                                    </td>
                                                                    <td align="right"><strong
                                                                            class="grandtotal"></strong>
                                                                    </td>
                                                                    <td align="right"><strong class=""></strong>
                                                                    </td>
                                                                </tr>
                                                            </tfoot>


                                                            <div
                                                                class="col-md-12">
                                                                <table class="">
                                                                    <tr>
                                                                        <td>
                                                                            <textarea  cols="100"
                                                                                class="form-control" name="narration" placeholder="Note......" type="text">
                                                                                    </textarea>
                                                                        </td>
                                                                        <td>
                                                                            <div class="panel  panel-default">
                                                                                <div class="panel-body">

                                                                                    <table
                                                                                        class="table table-bordered table-hover ">
                                                                                        <tbody>
                                                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Total </strong>
                                                                                                </td>
                                                                                                <td align="right"> <strong
                                                                                                        id="gtoal"
                                                                                                        class="grandtotal"></strong>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Previous Due </strong>
                                                                                                </td>
                                                                                                <td align="right"> <strong id="previous_due">0</strong>
                                                                                                    <input type="hidden" id="previouse_due_amount" name="previouse_due_amount" >
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Discount ( -
                                                                                                        )</strong>
                                                                                                </td>
                                                                                                <td>
                                                                                                    <div
                                                                                                        class="input-group">
                                                                                                        <input
                                                                                                            type="text"
                                                                                                            autocomplete="off"
                                                                                                            onkeyup="discountCalculation(this.value)"
                                                                                                            id="disCount"
                                                                                                            style="text-align: right"
                                                                                                            name="discount"
                                                                                                            value=""
                                                                                                            class="form-control"
                                                                                                            placeholder="0.00"
                                                                                                            oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                                                        <select
                                                                                                            id="discountType"
                                                                                                            class="form-control"
                                                                                                            onchange="discountCalculation(document.getElementById('disCount').value)">
                                                                                                            <option
                                                                                                                value="flat">
                                                                                                                Flat
                                                                                                            </option>
                                                                                                            <option
                                                                                                                value="percentage">
                                                                                                                Percentage
                                                                                                            </option>
                                                                                                        </select>
                                                                                                    </div>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Carrying Cost (
                                                                                                        + )
                                                                                                    </strong>
                                                                                                </td>
                                                                                                <td><input type="text"
                                                                                                        autocomplete="off"
                                                                                                        onkeyup="carrying_cost_Calculation(this.value)"
                                                                                                        id="carrying_cost"
                                                                                                        style="text-align: right"
                                                                                                        name="carrying_cost"
                                                                                                        class="form-control"
                                                                                                        placeholder="0.00"
                                                                                                        oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Labor bill ( + )
                                                                                                    </strong>
                                                                                                </td>
                                                                                                <td><input type="text"
                                                                                                        autocomplete="off"
                                                                                                        onkeyup="labor_bill_Calculation(this.value)"
                                                                                                        id="labor_bill"
                                                                                                        style="text-align: right"
                                                                                                        name="labor_bill"
                                                                                                        class="form-control"
                                                                                                        placeholder="0.00"
                                                                                                        oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                                                </td>
                                                                                            </tr>
                                                                                             <tr id="netTotal">
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Net
                                                                                                        Total</strong>
                                                                                                </td>
                                                                                                <td align="right"><strong
                                                                                                        id="ntotal"
                                                                                                        class="grandtotal"></strong>
                                                                                                </td>
                                                                                            </tr>
                                                                                             <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Advance Payments
                                                                                                        <button
                                                                                                            type="button"
                                                                                                            class="btn btn-sm btn-success ml-2"
                                                                                                            id="addAdvanceBtn">
                                                                                                            <i
                                                                                                                class="fa fa-plus"></i>
                                                                                                        </button>
                                                                                                    </strong>
                                                                                                </td>
                                                                                                <td>
                                                                                                    <div
                                                                                                        id="advanceContainer">
                                                                                                        <!-- First advance row (default) -->
                                                                                                        <div class="advance-row mb-2"
                                                                                                            data-index="0">
                                                                                                            <div
                                                                                                                class="row">
                                                                                                                <div
                                                                                                                    class="col-md-5">
                                                                                                                    <select
                                                                                                                        name="advance_ledger_id[0]"
                                                                                                                        class="form-control select2 advance-ledger"
                                                                                                                        data-index="0">
                                                                                                                        <option
                                                                                                                            value="">
                                                                                                                            --Select
                                                                                                                            Account--
                                                                                                                        </option>
                                                                                                                        <x-banck
                                                                                                                            :setAccounts="$accounts" />
                                                                                                                    </select>
                                                                                                                </div>
                                                                                                                <div
                                                                                                                    class="col-md-5">
                                                                                                                    <input
                                                                                                                        type="text"
                                                                                                                        autocomplete="off"
                                                                                                                        onkeyup="calculateAdvanceTotal()"
                                                                                                                        class="form-control advance-amount"
                                                                                                                        name="advance[0]"
                                                                                                                        data-index="0"
                                                                                                                        style="text-align: right"
                                                                                                                        placeholder="0.00"
                                                                                                                        oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                                                                </div>
                                                                                                                <div
                                                                                                                    class="col-md-2">
                                                                                                                    <button
                                                                                                                        type="button"
                                                                                                                        class="btn btn-sm btn-danger remove-advance"
                                                                                                                        data-index="0"
                                                                                                                        style="display: none;">
                                                                                                                        <i
                                                                                                                            class="fa fa-minus"></i>
                                                                                                                    </button>
                                                                                                                </div>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <!-- Total advance display -->
                                                                                                    <div class="mt-2">
                                                                                                        <strong>Total
                                                                                                            Advance: <span
                                                                                                                id="totalAdvanceAmount">0.00</span></strong>
                                                                                                        <input
                                                                                                            type="hidden"
                                                                                                            id="totalAdvanceHidden"
                                                                                                            name="total_advance"
                                                                                                            value="0">
                                                                                                    </div>
                                                                                                </td>
                                                                                            </tr>
                                                                                           
                                                                                            <tr id="account_id">
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Account <span
                                                                                                            style="color:red;">
                                                                                                            *
                                                                                                        </span></strong>
                                                                                                </td>
                                                                                                <td>
                                                                                                    <select name="account_id" class="form-control select2">
                                                                                                        <option selected value="0">Due</option>
                                                                                                        <x-banck :setAccounts="$accounts" />
                                                                                                     </select>
                                                                                                </td>
                                                                                            </tr>

                                                                                            <tr class="partisals d-none">
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Payment ( -
                                                                                                        )<span
                                                                                                            style="color:red;">
                                                                                                            *
                                                                                                        </span></strong>
                                                                                                </td>
                                                                                                <td><input type="text"
                                                                                                        id="payment"
                                                                                                        onkeyup="paymentCalculation(this.value)"
                                                                                                        style="text-align: right"
                                                                                                        name="partialPayment"
                                                                                                        value=""
                                                                                                        readonly
                                                                                                        class="form-control"
                                                                                                        autocomplete="off"
                                                                                                        placeholder="0.00"
                                                                                                        oninput="this.value = this.value.replace(/[^0-9.]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');" />
                                                                                                </td>

                                                                                                <!-- <input type="hidden" id="duePayment" style="text-align: right" name="duePayment" value="" readonly class="form-control" placeholder="0.00" /> -->
                                                                                            </tr>

                                                                                            <tr>
                                                                                                <td nowrap align="right">
                                                                                                    <strong>Total
                                                                                                        Due</strong>
                                                                                                </td>
                                                                                                <td align="right"><strong
                                                                                                        id="totalDue"
                                                                                                        class="grandtotal finalDue"></strong>
                                                                                                </td>
                                                                                            </tr>
                                                                                        </tbody>
                                                                                    </table>

                                                                                </div>
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </table>

                                                    </div>
                                    <td>
                                        <div class="clearfix"></div>
                                        <div class="clearfix form-actions float-right">
                                            <div class="col-md-offset-1 col-md-10">
                                                <button class="btn btn-info float-right" id="subMitButton"
                                                    type="submit">
                                                    Save
                                                </button>
                                                &nbsp; &nbsp; &nbsp;

                                            </div>
                                        </div>
                                    </td>
                        </div>
                </div>

            </div>

            </td>
            </tr>

            </table>



        </div>

        </form>
    </div>
    </div>
    </div>
    <!-- /.col-->
    </div>

    <div class="modal fade" id="addCustomerModel" tabindex="-1" role="dialog" aria-labelledby="addCustomerModelLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addCustomerModelLabel">Add Customer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" id="addCustomerFOrm" action="{{ route('sale.sale.quiceAddCustomer') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Company Name :</label>
                                    <input type="text" name="co_name" class="form-control" id="validationCustom01"
                                        placeholder="Company Name" value="{{ old('co_name') }}">
                                </div>
                            </div>
                            <div class="col-md-6 d-none">
                                <div class="form-group">
                                    <label for="validationCustom01">Customer Group Name *:</label>
                                    <select name="customergroup_id" class="form-control select2">
                                        <option value="0">Not Applicable</option>
                                        @foreach ($customerGroup as $data)
                                            <option value="{{ $data->id }}">{{ $data->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Contact Person *:</label>
                                    <input type="text" name="name" class="form-control" id="validationCustom01"
                                        placeholder="Contact Person" value="{{ old('name') }}" required>
                                </div>
                            </div>
                             <div class="col-md-6 mb-3">
                                <label for="validationCustom01">Branch * :</label>
                                <select class="form-control select2" id="branch_id" name="branch_id">
                                 
                                    @foreach ($branch as $key => $value)
                                    @if($value->id ==1)
                                        <option value="{{ $value->id }}">
                                            {{ $value->branchCode . ' - ' . $value->name }}
                                        </option>
                                        @endif
                                    @endforeach
                                </select>
                                @error('branch_id')
                                    <span class="error text-red text-bold">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom02">E-mail:</label>
                                    <input type="text" name="email" class="form-control" id="validationCustom02"
                                        placeholder="E-mail" value="{{ old('email') }}" >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom01">Phone *:</label>
                                    <input type="text" name="phone" class="form-control" id="validationCustom01"
                                        placeholder="Phone" value="{{ old('phone') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom02">Address *:</label>
                                    <input name="address" class="form-control" id="validationCustom02"
                                        placeholder="Address" value="{{ old('address') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validationCustom07">Bin:</label>
                                    <input name="bin" class="form-control" id="validationCustom07" placeholder="Bin"
                                        value="{{ old('bin') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save Customer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script type="text/javascript">
$(document).ready(function () {
    // Customer ledger change handler
    $('#ledger_id').on('change', function () {
        var ledgerId = $(this).val();

        if (ledgerId) {
            $.ajax({
                url: '{{route("sale.sale.olddueamount")}}',
                type: 'GET',
                data: { account_id: ledgerId },
                success: function (response) {
                    $("#previous_due").text(response);
                    $("#previouse_due_amount").val(response);
                    calculateFinalTotals();
                },
                error: function (xhr) {
                    console.error('Error:', xhr.responseText);
                }
            });
        }
    });

    // Customer Create Form Handler
    $('#addCustomerFOrm').on('submit', function (e) {
        e.preventDefault();

        const form = $(this);
        const formData = form.serialize();

        // Clear previous errors
        form.find('.text-danger').remove();
        form.find('.is-invalid').removeClass('is-invalid');

        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: formData,
            success: function (response) {
                if (response.success) {
                    $('#addCustomerModel').modal('hide');
                    $('select[name="ledger_id"]').append(
                        `<option value="${response.accounts.id}" selected>${response.accounts.account_name}</option>`
                    );
                    form[0].reset();
                } else {
                    alert('Unexpected error occurred.');
                }
            },
            error: function (xhr) {
                form.find("button[type='submit']").prop('disabled', false);

                if (xhr.status === 422) {
                    const errors = xhr.responseJSON.errors;
                    for (const field in errors) {
                        const input = form.find(`[name="${field}"]`);
                        input.addClass('is-invalid');
                        input.after(`<span class="text-danger">${errors[field][0]}</span>`);
                    }
                } else {
                    alert('Something went wrong. Please try again.');
                }
            }
        });

        form.find("button[type='submit']").prop('disabled', true);
    });

    // Gas quantity calculation
    $('#cty_size, #qty').on('input', function() {
        let ctyval = $('#cty_size').val();
        let qty = $('#qty').val();
        let gas_qty = ctyval * qty;
        $('#gas_qty').val(gas_qty);
    });

    // Branch change handler
    $('#branch_id').on('change', function() {
        $(".catName").val(null).trigger("change");
        $(".proName").val(null).trigger("change");
    });

    // =================== MULTIPLE PAYMENT METHODS ===================
    let paymentIndex = 1;

    // Add payment method row
    $('#addPaymentBtn').on('click', function() {
        const newPaymentRow = `
            <div class="payment-row mb-2" data-index="${paymentIndex}">
                <div class="row">
                   
                    <div class="col-md-3">
                        <select name="payment_account[${paymentIndex}]" class="form-control select2 payment-account" data-index="${paymentIndex}">
                            <option value="">--Select Account--</option>
                            <x-banck :setAccounts="$accounts" />
                        </select>
                    </div>
                    <div class="col-md-3">
                        <input type="text" 
                               autocomplete="off" 
                            
                               class="form-control payment-amount" 
                               name="payment_amount[${paymentIndex}]" 
                               data-index="${paymentIndex}" 
                               style="text-align: right" 
                               placeholder="0.00"
 />
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-sm btn-danger remove-payment" data-index="${paymentIndex}">
                            <i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="row mt-1" id="payment-details-${paymentIndex}" style="display: none;">
                    <div class="col-md-6">
                        <input type="text" name="payment_reference[${paymentIndex}]" class="form-control" placeholder="Reference/Transaction ID">
                    </div>
                    <div class="col-md-6">
                        <input type="text" name="payment_note[${paymentIndex}]" class="form-control" placeholder="Note">
                    </div>
                </div>
            </div>
        `;
        
        $('#paymentContainer').append(newPaymentRow);
        $('.select2').select2(); // Reinitialize select2
        paymentIndex++;
        
        // Show remove button for all rows if more than one
        if ($('.payment-row').length > 1) {
            $('.remove-payment').show();
        }
    });

    // Remove payment method row
    $(document).on('click', '.remove-payment', function() {
        const index = $(this).data('index');
        $(`.payment-row[data-index="${index}"]`).remove();
        calculatePaymentTotal();
        
        // Hide remove button if only one row remains
        if ($('.payment-row').length <= 1) {
            $('.remove-payment').hide();
        }
    });

    // Payment method change handler
    $(document).on('change', '.payment-method', function() {
        const index = $(this).data('index');
        const method = $(this).val();
        const detailsRow = $(`#payment-details-${index}`);
        
        if (method && method !== 'cash') {
            detailsRow.show();
        } else {
            detailsRow.hide();
        }
    });

    // =================== ADVANCE PAYMENTS ===================
    let advanceIndex = 1;

    // Add advance payment row
    $('#addAdvanceBtn').on('click', function() {
        const newAdvanceRow = `
            <div class="advance-row mb-2" data-index="${advanceIndex}">
                <div class="row">
                    <div class="col-md-5">
                        <select name="advance_ledger_id[${advanceIndex}]" class="form-control select2 advance-ledger" data-index="${advanceIndex}">
                            <option value="">--Select Account--</option>
                            <x-banck :setAccounts="$accounts" />
                        </select>
                    </div>
                    <div class="col-md-5">
                        <input type="text" 
                               autocomplete="off" 
                               onkeyup="calculateAdvanceTotal()" 
                               class="form-control advance-amount" 
                               name="advance[${advanceIndex}]" 
                               data-index="${advanceIndex}" 
                               style="text-align: right" 
                               placeholder="0.00"
                              />
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-sm btn-danger remove-advance" data-index="${advanceIndex}">
                            <i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        
        $('#advanceContainer').append(newAdvanceRow);
        $('.select2').select2(); // Reinitialize select2
        advanceIndex++;
        
        // Show remove button for all rows if more than one
        if ($('.advance-row').length > 1) {
            $('.remove-advance').show();
        }
    });

    // Remove advance payment row
    $(document).on('click', '.remove-advance', function() {
        const index = $(this).data('index');
        $(`.advance-row[data-index="${index}"]`).remove();
        calculateAdvanceTotal();
        
        // Hide remove button if only one row remains
        if ($('.advance-row').length <= 1) {
            $('.remove-advance').hide();
        }
    });

    // =================== ITEM MANAGEMENT ===================
    
    // Add item to invoice
    $("#add_item").click(function() {
        // Validation checks
        let seaschproduct = $('#productID option:selected')[0].getAttribute("value");
        let tbody = $('tbody').find(".new_item" + seaschproduct).length;
        
        var purchasetypeval = $('.purchasetype').find('option:selected').val();
        var purchasetypetext = $('.purchasetype').find('option:selected').text();
        var team = $('.team').val();
        var proId = $('.proName').val();
        var proName = $(".proName").find('option:selected').attr('proName');
        var unit = $('.unit').val();
        var qty = $('.qty').val();
        var vat = parseFloat($('#vat').val()) || 0;
        var patmentType = $('input[name="payment_type"]:checked').val();
        var customer_id = $('#customer_id').val();
        var unitprice = $('.unitprice').val();
        var total = $('.total').val();

        if (proId == '' || proId == null) {
            alertMessage.error("Product can't be empty.");
            return false;
        }

        if (qty == '' || qty == null || qty == 0) {
            alertMessage.error("Quantity can't be empty or zero.");
            return false;
        } else {
            if (customer_id === null) {
                alertMessage.error("Please select a Customer.");
                return false;
            }

            if (patmentType === undefined) {
                alertMessage.error("Please select Payment Type.");
                return false;
            }

            // Check for duplicate products
            // var exists = false;
            // $('#show_item tbody tr:not(:first)').each(function() {
            //     var existingProId = $(this).find('input[name="proName[]"]').val();
            //     var existingType = $(this).find('input[name="purchasetype[]"]').val();
            //     if (existingProId === proId && existingType === purchasetypeval) {
            //         exists = true;
            //         return false;
            //     }
            // });

            // if (exists) {
            //     showAlert('This product with same fabric type already exists', 'error');
            //     return false;
            // }

            // Add item to table
            $("#show_item tbody").append(
                '<tr class="new_item' + proId + '">' +
                    '<td align="right">' +
                        proName +
                        '<input type="hidden" class="add_quantity" name="proName[]" value="' + proId + '">' +
                    '</td>' +
                    '<td align="right">' +
                        qty +
                        '<input type="hidden" class="ttlqty" name="qty[]" value="' + qty + '">' +
                    '</td>' +
                    '<td align="right">' +
                        unitprice +
                        '<input type="hidden" class="ttlunitprice unitparice" name="unitprice[]" value="' + unitprice + '">' +
                    '</td>' +
                    '<td align="right">' +
                        total +
                        '<input type="hidden" class="grandtotal" name="total[]" value="' + total + '">' +
                    '</td>' +
                    '<td>' +
                        '<a del_id="' + proId + '" class="delete_item btn form-control btn-danger" href="javascript:;" title="">' +
                            '<i class="fa fa-times"></i>' +
                        '</a>' +
                    '</td>' +
                '</tr>'
            );
        }

        // Clear form fields
        $(".proName").val(null).trigger("change");
        $("#currentStock").val("");
        $("#qty").val("");
        $("#cty_size").val("");
        $("#gas_qty").val("");
        $(".unitprice").val("");
        $(".ttlamount").val("");

        // Recalculate totals
        findqtyamount();
        findunitamount();
        findgrandtottal();
        checkDepositAndCreditBalance();
        calculateAdvanceTotal();
        calculatePaymentTotal();
    });

    // Delete item from invoice
    $(document).on('click', '.delete_item', function() {
        let deleteitem = () => {
            var id = $(this).attr("del_id");
            $('.new_item' + id).remove();
            findqtyamount();
            findunitamount();
            findgrandtottal();
            checkDepositAndCreditBalance();
            calculateAdvanceTotal();
            calculatePaymentTotal();
        }

        alertMessage.confirm('You want to remove this', deleteitem);
    });

    // =================== CALCULATION FUNCTIONS ===================

    var findqtyamount = function() {
        var ttlqty = 0;
        $.each($('.ttlqty'), function() {
            qty = $(this).val();
            qty = Number(qty);
            ttlqty += qty;
        });
        $('.ttlqty').text(parseFloat(ttlqty).toFixed(2));
    };

    var findunitamount = function() {
        var ttlunitprice = 0;
        $.each($('.ttlunitprice'), function() {
            unitprice = $(this).val();
            unitprice = Number(unitprice);
            ttlunitprice += unitprice;
        });
        $('.ttlunitprice').text(parseFloat(ttlunitprice).toFixed(2));
    };

    var findgrandtottal = function() {
        var grandtotal = 0;
        $.each($('.grandtotal'), function() {
            total = $(this).val();
            total = Number(total);
            grandtotal += total;
        });

        $('.grandtotal').text(parseFloat(grandtotal).toFixed(2));
        calculateFinalTotals();
    };

    // Calculate advance total
    window.calculateAdvanceTotal = function() {
        let totalAdvance = 0;
        $('.advance-amount').each(function() {
            let amount = parseFloat($(this).val()) || 0;
            totalAdvance += amount;
        });
        
        $('#totalAdvanceAmount').text(totalAdvance.toFixed(2));
        $('#totalAdvanceHidden').val(totalAdvance.toFixed(2));
        calculateFinalTotals();
    };

    // Calculate payment total
    window.calculatePaymentTotal = function() {
        let totalPayment = 0;
        $('.payment-amount').each(function() {
            let amount = parseFloat($(this).val()) || 0;
            totalPayment += amount;
        });
        
        $('#totalPaymentAmount').text(totalPayment.toFixed(2));
        $('#totalPaymentHidden').val(totalPayment.toFixed(2));
        $('#payment').val(totalPayment.toFixed(2));
        calculateFinalTotals();
    };

    // Calculate final totals
    function calculateFinalTotals() {
        var gtoal = parseFloat(document.getElementById("gtoal").innerText) || 0;
        var carrying_cost = parseFloat($("#carrying_cost").val()) || 0;
        var discount = parseFloat($("#disCount").val()) || 0;
        var labor_bill = parseFloat($("#labor_bill").val()) || 0;
        var totalAdvance = parseFloat($('#totalAdvanceHidden').val()) || 0;
        var totalPayment = parseFloat($('#totalPaymentHidden').val()) || 0;
        var previouse_due_amount = parseFloat($("#previouse_due_amount").val()) || 0;
        
        // Calculate discount amount based on type
        var discountAmount = discount;
        var discountType = document.getElementById("discountType").value;
        if (discountType === "percentage") {
            discountAmount = (gtoal * discount) / 100;
        }
        
        // Calculate net total
        var netTotal = gtoal + carrying_cost + labor_bill + previouse_due_amount - discountAmount;
        $('#ntotal').text(netTotal.toFixed(2));
        
        // Calculate final due
        var finalDue = netTotal - totalAdvance - totalPayment;
        $('#totalDue').text(finalDue.toFixed(2));
    }
});

// =================== STANDALONE FUNCTIONS ===================

function checkDepositAndCreditBalance() {
    var paymentType = $("#paymentType").val();

    if (paymentType == '') {
        paymentType = 'Cash';
    }

    var customer_currentBalance = $("#customer_currentBalance").val();
    var totalDue = $("#totalDue").text();
    var expireDatas = $("#expireData").val();
    var todaysDate = new Date().toISOString().slice(0, 10);

    if (expireDatas == '') {
        expireDatas = todaysDate;
    }
    
    var btn = document.getElementById('subMitButton');
    if ((paymentType == 'Deposit') && (parseFloat(customer_currentBalance) < parseFloat(totalDue))) {
        btn.disabled = true;
    } else if (paymentType == 'Cash') {
        btn.disabled = false;
    } else {
        btn.disabled = false;
    }
}

function showAlert(message, type = 'info') {
    if (typeof alertMessage !== 'undefined') {
        alertMessage[type](message);
    } else {
        alert(message);
    }
}

function discountCalculation(amount) {
    var gtoal = parseFloat(document.getElementById("gtoal").innerText);
    var discountType = document.getElementById("discountType").value;
    var discount = parseFloat(amount) || 0;

    if (discountType === "percentage") {
        if (discount > 100) {
            alertMessage.error("Percentage discount cannot exceed 100%");
            $('#disCount').val('');
            calculateFinalTotals();
            return;
        }
    }

    var discountAmount = discountType === "percentage" ? (gtoal * discount) / 100 : discount;
    
    if (discountAmount > gtoal) {
        alertMessage.error("Discount cannot be greater than the total amount");
        $('#disCount').val('');
        calculateFinalTotals();
        return;
    }

    calculateFinalTotals();
}

function carrying_cost_Calculation(amount) {
    calculateFinalTotals();
}

function labor_bill_Calculation(amount) {
    calculateFinalTotals();
}

function advance_amount(amount) {
    calculateFinalTotals();
}

function paymentCalculation(payamount) {
    calculateFinalTotals();
}

function qtyPriceCal() {
    var qty = $('#qty').val();
    var unitpice = $('#unitpice').val();
    var vat = parseFloat($('#vat').val()) || 0;

    var totalWithoutVAT = unitpice * qty;
    var vatAmount = (vat > 0) ? (vat / 100) * totalWithoutVAT : 0;
    var totalWithVAT = totalWithoutVAT + vatAmount;
    var ttlqtys = document.getElementById('total').value = totalWithVAT.toFixed(2);
}

function getProductList(cat_id) {
    var branch_id = $('#branch_id').val();

    if (branch_id == null) {
        alertMessage.error('Branch Are not selected');
        return;
    }

    $.ajax({
        "url": "{{ route('sale.sale.getProductListForSale') }}",
        "type": "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            cat_id: cat_id,
            branch_id: branch_id
        },
        success: function(data) {
            $('#productID').select2();
            $('#productID option').remove();
            $('#productID').append($(data));
            $("#productID").trigger("select2:updated");
        }
    });
}

function getCustomerBalance(payment_type) {
    var customer_id = $('#customer_id').val();
    if (!customer_id) {
        alertMessage.error('Please Select Customer');
        return
    }
    $("#paymentType").val(payment_type);

    if (payment_type == 'Cash') {
        $('#account_id').show();
        $('#netTotal').show();
        $('.partisals').show();
        calculatetotal();
    } else {
        calculatetotal();
        $('.partisals').css('display', 'none');
        $('#account_id').css('display', 'none');
        $('#netTotal').css('display', 'none');
    }

    $.ajax({
        "url": "{{ route('sale.sale.getCustomerBalance') }}",
        "type": "GET",
        cache: false,
        dataType: "json",
        data: {
            "_token": "{{ csrf_token() }}",
            customer_id: customer_id,
            payment_type: payment_type
        },
        success: function(data) {
            if (payment_type == 'Cash') {
                $("#customer_currentBalance").val('');
            } else {
                $("#customer_currentBalance").val(data.finalBalance);
                $("#expireData").val(data.expireData);
            }
        }
    });
}

var calculatetotal = function() {
    var grandtotal = 0;
    $.each($('.grandtotal'), function() {
        total = $(this).val();
        total = Number(total);
        grandtotal += total;
    });

    if (parseFloat(grandtotal) > 0) {
        $('.grandtotal').text(parseFloat(grandtotal).toFixed(2));
        calculateFinalTotals();
    }
};

function getUnitPrice(v) {
    let branch_id = $('#branch_id option:selected').val();
    let sub_branch_id = $('#sub_warehouse_id option:selected').val();
    let purchasetype = $('.purchasetype option:selected').val();
    let productId = $('#productID option:selected').val();
    
    $.ajax({
        "url": "{{ route('sale.sale.saleunitPrice') }}",
        "type": "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            'productId': productId,
        },
        success: function(data) {
            $("#unitpice").val(data.sale_price);
            $(".purchaseprice").html("Last PP :" + data.lastPurchasePrice);
        }
    });

    $.ajax({
        "url": "{{ route('sale.sale.getProductStock') }}",
        "type": "GET",
        cache: false,
        data: {
            "_token": "{{ csrf_token() }}",
            productId: productId,
            type: purchasetype,
            branch_id: branch_id,
            sub_branch_id: sub_branch_id,
        },
        success: function(data) {
            $("#currentStock").val(data);
        }
    });
}

// Initialize on page load
getCustomerBalance('Due');
    </script>
@endsection
