@extends('backend.layouts.master')

@section('title')
  {{ __('User Manager - ') . $title }}
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('User Manage') }} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if (helper::roleAccess('usermanage.buyer.index'))
              <li class="breadcrumb-item">
                <a href="{{ route('usermanage.buyer.index') }}">{{ __('Buyer List') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ __('Add New User') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ $title }}</h3>
          <div class="card-tools">
            @if (helper::roleAccess('usermanage.buyer.index'))
              <a class="btn btn-default" href="{{ route('usermanage.buyer.index') }}">
                <i class="fa fa-list"></i>
                <span>{{ __('Buyer List') }}</span>
              </a>
            @endif
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <form class="needs-validation" method="POST" action="{{ route('usermanage.buyer.store') }}" novalidate > 
            @csrf
            <div class="form-row">
              <div class="col-md-3 mb-3">
                <label for="name">{{ __('Name * :') }}</label>
                <input type="text" name="name" class="form-control form-control-sm" id="name" placeholder="Name" value="{{ old('name') }}" />
                @error('name')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              <div class="col-md-3 mb-3">
                <label for="email"> {{ __('Email * :') }}</label>
                <input type="text" name="email" class="form-control form-control-sm" id="email" placeholder="Email" value="{{ old('email') }}" required />
                @error('email')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              <div class="col-md-3 mb-3">
                <label for="phone">{{ __('Phone * :') }}</label>
                <input type="text" name="phone" class="form-control form-control-sm" id="phone" placeholder="Phone" value="{{ old('phone') }}" required />
                @error('phone')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              <div class="col-md-3 mb-3">
                <label for="company_name">{{ __('Company Name * :') }}</label>
                <input type="text" name="company_name" class="form-control form-control-sm" id="company_name" placeholder="Company Name" value="{{ old('company_name') }}" />
                @error('company_name')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              <div class="col-md-4 mb-3">
                <label for="address">{{ __('Address * :') }}</label>
                <input type="text" name="address" class="form-control form-control-sm" id="address" placeholder="Address" value="{{ old('address') }}" required />
                @error('address')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              {{-- <div class="col-md-4 mb-3" id="showBranch" style="display: none">
                <label for="validationCustom01">{{ __('Branch Name * :') }}</label>
                <select name="branch_id" id="" class="form-control select2">
                  <option selected disabled value="{{ $value->id }}">{{ __('--Select Branch--') }}</option>
                  @foreach ($branchs as $key => $value)
                    <option value="{{ $value->id }}">{{ $value->branchCode.'-'.$value->name }}</option>
                  @endforeach
                </select>
                @error('branch_id')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div> --}}

              <div class="col-md-3 mb-3">
                <label for="password">{{ __('Password * :') }}</label>
                <input type="password" name="password" class="form-control form-control-sm" id="password" placeholder="Password" value="{{ old('password') }}" required />
                @error('password')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              <div class="col-md-3 mb-3">
                <label for="password_confirmation">{{ __('Confirm Password * :') }}</label>
                <input type="password" name="password_confirmation" class="form-control form-control-sm" id="password_confirmation" placeholder="Confirm Password" value="{{ old('password_confirmation') }}" required />
                @error('password_confirmation')
                  <span class=" error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>

              <div class="col-md-2 mb-3">
                <label for="status">{{ __('Status :') }}</label>
                <select name="status" id="status" class="form-control select2" >
                  <option value="" selected disabled>{{ __('Select Status') }}</option>
                  <option value="Active">{{ __('Active') }}</option>
                  <option value="Inactive">{{ __('Inactive') }}</option>
                  <option value="Pending">{{ __('Pending') }}</option>
                </select>
                @error('status')
                  <span class="error text-red text-bold">{{ $message }}</span>
                @enderror
              </div>
            </div>
            <button class="btn btn-info" type="submit">
              <i class="fa fa-save"></i>
              <span>&nbsp; {{ __('Save') }}</span>
            </button>
          </form>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>

  <script>
    function showBranchDiv(type) {
      if (type != "Project") {
        $("#showBranch").show(500);
      } else {
        $("#showBranch").hide(500);
      }
    }
  </script>
@endsection