@extends('backend.layouts.master')
@section('title')
  {{ __('User Manager - ') . $title }}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('User Manage') }} </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ route('home') }}">{{ __('Dashboard') }}</a>
            </li>
            @if (helper::roleAccess('usermanage.buyer.index'))
              <li class="breadcrumb-item">
                <a href="{{ route('usermanage.buyer.index') }}">{{ __('Buyer') }}</a>
              </li>
            @endif
            <li class="breadcrumb-item active">
              <span>{{ ('Buyer List') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ __('Buyer List') }}</h3>
          <div class="card-tools">
            <a class="btn btn-default" href="{{ route('usermanage.buyer.create') }}">
              <i class="fas fa-plus"></i>
              <span>{{ __('Add New') }}</span>
            </a>
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <div class="table-responsive">
            <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
              <thead>
                <tr>
                  <th>{{ __('SL') }}</th>
                  <th>{{ __('Name') }}</th>
                  <th>{{ __('Company Name') }}</th>
                  <th>{{ __('Email') }}</th>
                  <th>{{ __('Phone') }}</th>
                  <th>{{ __('Status') }}</th>
                  <th>{{ __('Action') }}</th>
                </tr>
              </thead>
              <tbody></tbody>
              <tfoot>
                <tr>
                  <th>{{ __('SL') }}</th>
                  <th>{{ __('Name') }}</th>
                  <th>{{ __('Company Name') }}</th>
                  <th>{{ __('Email') }}</th>
                  <th>{{ __('Phone') }}</th>
                  <th>{{ __('Status') }}</th>
                  <th>{{ __('Action') }}</th>
                </tr>
              </tfoot>
            </table>
          </div>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
@endsection
@section('scripts')
  @include('backend.pages.usermanage.buyers.script')
@endsection
