@extends('backend.layouts.master')

@section('title')
usermanage - {{ $title }}
@endsection
<style>
/* Updated CSS for better image preview */
.image-preview-container {
    position: relative;
    display: inline-block;
    margin: 10px 0;
}

.image-preview {
    max-width: 200px;
    max-height: 200px;
    border: 2px dashed #ddd;
    border-radius: 8px;
    padding: 10px;
    /* Show preview if image exists, hide if not */
    display: {{ $userDetails->logo && file_exists(public_path('/backend/logo/' . $userDetails->logo)) ? 'block' : 'none' }};
}

.image-preview img {
    max-width: 100%;
    max-height: 100%;
    border-radius: 4px;
    display: block;
}

.image-remove-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    background: #dc3545;
    color: white;
    border: none;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
}

.image-remove-btn:hover {
    background: #c82333;
}

.file-input-wrapper {
    position: relative;
    overflow: hidden;
    display: inline-block;
    width: 100%;
}

.file-input-wrapper input[type=file] {
    position: absolute;
    left: -9999px;
}

.file-input-label {
    display: block;
    padding: 10px 15px;
    cursor: pointer;
    background: #f8f9fa;
    border: 2px dashed #ddd;
    border-radius: 8px;
    text-align: center;
    transition: all 0.3s ease;
}

.file-input-label:hover {
    background: #e9ecef;
    border-color: #007bff;
}

.file-input-label i {
    font-size: 24px;
    color: #6c757d;
    margin-bottom: 5px;
}

.file-name {
    margin-top: 5px;
    font-size: 12px;
    color: #6c757d;
}

/* Additional styles for existing file display */
.existing-file-info {
    background: #e8f5e8;
    border: 1px solid #d4edda;
    border-radius: 4px;
    padding: 10px;
    margin-top: 10px;
    font-size: 12px;
    color: #155724;
}

.existing-file-info i {
    color: #28a745;
    margin-right: 5px;
}
</style>

@section('navbar-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Usermanage </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    @if (helper::roleAccess('usermanage.user.index'))
                    <li class="breadcrumb-item"><a href="{{ route('usermanage.user.index') }}">User List</a></li>
                    @endif
                    <li class="breadcrumb-item active"><span>Edit User</span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
@endsection

@section('admin-content')



<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">{{ $title }}</h3>
                <div class="card-tools">
                    @if (helper::roleAccess('usermanage.user.index'))
                    <a class="btn btn-default" href="{{ route('usermanage.user.index') }}"><i class="fa fa-list"></i>
                        User List</a>
                    @endif
                    <span id="buttons"></span>

                    <a class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form class="needs-validation" method="POST"
                    action="{{ route('usermanage.user.update', $userDetails->id) }}" novalidate enctype="multipart/form-data">
                    @csrf
                    <div class="form-row">
                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Name :</label>
                            <input type="text" name="name" class="form-control" id="validationCustom01"
                                placeholder="Name" value="{{ $userDetails->name }}">
                            @error('name')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="validationCustom02"> Email * :</label>
                            <input type="text" name="email" class="form-control" id="validationCustom02"
                                placeholder="Email" value="{{ $userDetails->email }}">
                            @error('email')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Role Name * :</label>
                            <select name="role_name" id="" class="form-control ">
                                <option>--Select Role--</option>
                                @foreach ($userRoll as $key => $value)
                                <option {{ $userDetails->role_id == $value->id ? 'selected' : '' }}
                                    value="{{ $value->id }}">{{ $value->role_name }}</option>
                                @endforeach
                            </select>
                            @error('role_name')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="validationCustom02"> Type *:</label>
                            <select name="type" id="utype" class="form-control select2"
                                onchange="showBranchDiv(this.value)">
                                <option {{ $userDetails->type == 'Admin' ? 'selected' : '' }} value="Admin">Admin
                                </option>
                                <option {{ $userDetails->type == 'Employee' ? 'selected' : '' }} value="Employee">
                                        Employee</option>
                                <!-- <option {{ $userDetails->type == 'Project' ? 'selected' : '' }} value="Project">
                                        Project</option> -->
                            </select>
                            @error('type')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>



                        <div class="col-md-4 mb-3" id="showBranch" style="display: none">
                            <label for="validationCustom01">Branch Name * :</label>
                            <select name="branch_id" id="" class="form-control select2">
                                <!-- <option selected value="0">All Branch</option> -->
                                @foreach ($branchs as $key => $value)
                                <option {{ $userDetails->branch_id == $value->id ? 'selected' : '' }}
                                    value="{{ $value->id }}">{{ $value->name }}</option>
                                @endforeach
                            </select>
                            @error('branch_id')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="col-md-4 mb-3" >
                            <label for="validationCustom01">Employee  * :</label>
                            <select name="employee_id" id="" class="form-control select2">
                                <option selected  value="0">--Select Employee--</option>
                                @foreach ($employess as $key => $employes)
                                <option {{ $userDetails->employee_id == $employes->id ? 'selected' : '' }} value="{{ $employes->id }}">{{ $employes->name }}</option>
                                @endforeach
                            </select>
                            @error('branch_id')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>


                        <div class="col-md-4 mb-3">
                            <label for="validationCustom02"> Phone * :</label>
                            <input type="text" name="phone" class="form-control" id="validationCustom02"
                                placeholder="Phone" value="{{ $userDetails->phone }}" required>
                            @error('phone')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Password * :</label>
                            <input type="password" name="password" class="form-control" id="validationCustom01"
                                placeholder="Password" value="{{ old('password') }}" required>
                            @error('password')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Confirm Password * :</label>
                            <input type="password" name="password_confirmation" class="form-control"
                                id="validationCustom01" placeholder="Confirm Password"
                                value="{{ old('password_confirmation') }}" value="{{ old('password') }}" required>
                            @error('password_confirmation')
                            <span class=" error text-red text-bold">{{ $message }}</span>
                            @enderror
                        </div>

                           <div class="col-md-6 mb-3">

                            <div class="form-group" style="display: flex; gap:10px">
                               
                                <div class="file-input-wrapper">
                                     <label>Image</label>
                                    <input type="file" 
                                           id="voucher-input" 
                                           name="image" 
                                           accept="image/*,.pdf,.doc,.docx"
                                           class="@error('image') is-invalid @enderror">
                                    <label for="voucher-input" class="file-input-label">
                                        <i class="fa fa-cloud-upload"></i>
                                        <div>Click to select file</div>
                                        <small>Images, PDF, DOC files supported</small>
                                    </label>
                                    <div class="file-name" id="file-name"></div>
                                     @error('image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                </div>
                               
                                
                                <!-- Image Preview Container -->
                                 <div class="image-preview" id="image-preview">
                                            @if ($editInfo->logo && file_exists(public_path('/backend/logo/' . $editInfo->logo)))
                                                <img id="preview-img"
                                                    src="{{ asset('/backend/logo/' . $editInfo->logo) }}" alt="Preview">
                                            @else
                                                <img id="preview-img" src="" alt="Preview"
                                                    style="display: none;">
                                            @endif
                                            <button type="button" class="image-remove-btn" id="remove-image">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                            </div>
                            </div>
                    </div>
                    <button class="btn btn-info" type="submit"><i class="fa fa-save"></i> &nbsp;Save</button>
                </form>
            </div>
            <!-- /.card-body -->
            <div class="card-footer">

            </div>
        </div>
    </div>
    <!-- /.col-->
</div>


<script>
    function showBranchDiv(type) {
        if (type != "Project") {
            $("#showBranch").show(500);
        } else {
            $("#showBranch").hide(500);
        }
    }
</script>

<script>
    $(document).ready(function () {
        let utype = $("#utype").val();
        if (utype == "Project") {
            $("#showBranch").hide(500);
        } else {
            $("#showBranch").show(500);
        }
    });
</script>
 <script>
        $(document).ready(function() {
            @if ($editInfo->logo)
                @if (file_exists(public_path('/backend/logo/' . $editInfo->logo)))
                    // Show existing image info
                    $('#file-name').html(`
                <div class="existing-file-info">
                    <i class="fa fa-check-circle"></i>
                    Current file: {{ $editInfo->logo }}
                </div>
            `);
                    $('#image-preview').show();
                @else
                    // File doesn't exist, show error
                    $('#file-name').html(`
                <div class="existing-file-info" style="background: #f8d7da; border-color: #f5c6cb; color: #721c24;">
                    <i class="fa fa-exclamation-triangle"></i>
                    Previous file not found: {{ $editInfo->logo }}
                </div>
            `);
                @endif
            @endif

            $('#voucher-input').on('change', function(e) {
                const file = e.target.files[0];
                const fileName = $('#file-name');
                const imagePreview = $('#image-preview');
                const previewImg = $('#preview-img');

                if (file) {
                    // Show file name
                    fileName.text(file.name);

                    // Check if file is an image
                    if (file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            previewImg.attr('src', e.target.result);
                            previewImg.show();
                            imagePreview.show();
                        }
                        reader.readAsDataURL(file);
                    } else {
                        // For non-image files, show file info
                        imagePreview.hide();
                        fileName.html(
                            `<i class="fa fa-file"></i> ${file.name} (${(file.size / 1024).toFixed(2)} KB)`
                            );
                    }

                    // Update label text
                    $('.file-input-label').html(`
                <i class="fa fa-check-circle" style="color: #28a745;"></i>
                <div>File selected successfully</div>
                <small>Click to change file</small>
            `);
                }
            });

            // Remove image functionality
            $('#remove-image').on('click', function() {
                $('#voucher-input').val('');
                $('#image-preview').hide();
                $('#preview-img').hide();
                $('#file-name').text('');
                $('.file-input-label').html(`
            <i class="fa fa-cloud-upload"></i>
            <div>Click to select file</div>
            <small>Images, PDF, DOC files supported</small>
        `);
            });

            // Drag and drop functionality
            $('.file-input-label').on('dragover', function(e) {
                e.preventDefault();
                $(this).addClass('drag-over');
            });

            $('.file-input-label').on('dragleave', function(e) {
                e.preventDefault();
                $(this).removeClass('drag-over');
            });

            $('.file-input-label').on('drop', function(e) {
                e.preventDefault();
                $(this).removeClass('drag-over');

                const files = e.originalEvent.dataTransfer.files;
                if (files.length > 0) {
                    $('#voucher-input')[0].files = files;
                    $('#voucher-input').trigger('change');
                }
            });

        })
    </script>



@endsection