@php
    $num = $countNum ?? 0;
    $selected = $selectVal ?? 0;
    $skip = $skip ?? [];
@endphp

@foreach ($setAccounts as $account)
    @if (in_array($account->id, $skip))
        @continue
    @endif

    @if ($account->subAccount->isNotEmpty())
        @include('backend.partials.account-options', [
            'setAccounts' => $account->subAccount,
            'skip' => $skip,
            'selectVal' => $selected,
            'countNum' => $num + 1
        ])
    @else
        <option value="{{ $account->id }}" {{ $selected == $account->id ? 'selected' : '' }}>
            {{ is_array($account->account_name) ? implode(', ', $account->account_name) : $account->account_name }}
            {{ is_array($account->account_code) ? implode(', ', $account->account_code) : $account->account_code }}
            {{ is_array($account->bank_name) ? implode(', ', $account->bank_name) : $account->bank_name }}
            @if ($account->accountable_type && $account->accountable_id)
                {{ is_array(optional($account->accountable)->phone) ? implode(', ', optional($account->accountable)->phone) : (optional($account->accountable)->phone ?? 'N/A') }}
            @endif
        </option>
    @endif
@endforeach
