
<?php $__env->startSection('title'); ?>
    <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Voucher </h1>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header no-print">
                    <h3 class="card-title">Credit Voucher Report</h3>
                    <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2 no-print"><i
                            class="fas fa-print"></i>
                        Print</a>
                    <div id="tableActions" class=" float-right my-2 no-print"></div>
                </div>

                <div class="card-body">

                    <div class="invoice p-3 mb-3">
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table  table-bordered">
                                    <tr>
                                        <td style="text-align: center">
                                            <?php if(isset($companyInfo->logo)): ?>
                                                <a href="<?php echo e(route('home')); ?>">
                                                    <img width="200px"
                                                        src="<?php echo e(asset('/backend/logo/' . $companyInfo->logo)); ?>"
                                                        style="" alt="">
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td width="70%" style="text-align: center">
                                            <h3>Receive Voucher</h3>
                                            <div class="row">
                                                <div class="col-md-12 text-center">
                                                    <p class="font-weight-bold"><?php echo e($companyInfo->address); ?></p>
                                                </div>
                                                <div class="col-md-6 text-left">No: <?php echo e($creditVoucher->id); ?></div>
                                                <div class="col-md-6 text-right">Date:
                                                    <?php echo e(date('d-M-Y', strtotime($creditVoucher->date))); ?></div>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                                <table id="datatablexcel" class="table table-striped table-bordered">
                                    <?php
                                    $count = 0;
                                    ?>
                                    <thead>
                                        <tr>
                                            <td height="25" width="5%"><strong>SL.</strong></td>
                                            <td width="10%"><strong>Date</strong></td>
                                            <td width="10%"><strong>Invoice No</strong></td>
                                            <td width="12%"><strong>Account</strong></td>
                                            <?php
                                                $voucher = $account_transactions->first();
                                            ?>
                                            <?php if(!empty($voucher->creditVoucher->project_id)): ?>
                                                <?php
                                                    $count += 1;
                                                ?>
                                                <td width="12%"><strong>Project</strong></td>
                                            <?php endif; ?>
                                            <?php if(!empty($voucher->creditVoucher->supplier_id)): ?>
                                                <?php
                                                    $count += 1;
                                                ?>
                                                <td width="12%"><strong>Supplier</strong></td>
                                            <?php endif; ?>
                                            <?php if(!empty($voucher->creditVoucher->customer_id)): ?>
                                                <?php
                                                    $count += 1;
                                                ?>
                                                <td width="12%"><strong>Customer</strong></td>
                                            <?php endif; ?>
                                            <?php if(!empty($voucher->creditVoucher->employee_id)): ?>
                                                <?php
                                                    $count += 1;
                                                ?>
                                                <td width="12%"><strong>Employee</strong></td>
                                            <?php endif; ?>

                                            <td width="10%" align="right">
                                                <strong>Credit</strong>
                                            </td>
                                            <td width="10%" align="right">
                                                <strong>Debit</strong>
                                            </td>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $totalCredit = 0;
                                            $totalDebit = 0;

                                        ?>
                                        <tr>
                                            
                                            
                                        </tr>

                                        <?php if(count($account_transactions) != 0): ?>
                                            <?php $__currentLoopData = $account_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="table_data">
                                                    <td align="right">
                                                        <strong><?php echo e($loop->iteration); ?></strong>
                                                    </td>
                                                    <td align="right">
                                                        <strong><?php echo e($transaction->creditVoucher->date); ?></strong>
                                                    </td>
                                                    <td align="right">
                                                        <strong><?php echo e($transaction->creditVoucher->voucher_no); ?></strong>
                                                    </td>
                                                    <td align="right">
                                                        <strong><?php echo e($transaction->account->account_name); ?></strong>
                                                    </td>
                                                    <?php if(!empty($voucher->creditVoucher->project_id)): ?>
                                                        <td align="right">
                                                            <strong><?php echo e($transaction->creditVoucher->project->name); ?></strong>
                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if(!empty($voucher->creditVoucher->supplier_id)): ?>
                                                        <td align="right">
                                                            <strong><?php echo e($transaction->creditVoucher->supplier->name); ?></strong>
                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if(!empty($voucher->creditVoucher->customer_id)): ?>
                                                        <td align="right">
                                                            <strong><?php echo e($transaction->creditVoucher->customer->name); ?></strong>
                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if(!empty($voucher->creditVoucher->employee_id)): ?>
                                                        <td align="right">
                                                            <strong><?php echo e($transaction->creditVoucher->employee->name); ?></strong>
                                                        </td>
                                                    <?php endif; ?>

                                                    <td align="right">
                                                        <?php
                                                        $totalCredit += $transaction->credit == null ? 0 : $transaction->credit;
                                                        ?>
                                                        <strong>
                                                            <?php echo e($transaction->credit == null ? 0 : $transaction->credit); ?></strong>

                                                    </td>
                                                    <td align="right">
                                                        <?php
                                                        $totalDebit += $transaction->debit == null ? 0 : $transaction->debit;
                                                        ?>
                                                        <strong>
                                                            <?php echo e($transaction->debit == null ? 0 : $transaction->debit); ?></strong>

                                                    </td>
                                                    
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="8" class="text-center">No Data Found</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="table_data">
                                            <td colspan="<?php echo e(3 + $count); ?>"><strong>Note:
                                                    <?php echo e($creditVoucher->note); ?></strong>
                                            </td>
                                            <td align="right"><strong>Total</strong>
                                            </td>
                                            <td align="right">
                                                <strong><?php echo e($totalCredit); ?></strong>
                                            </td>
                                            <td align="right">
                                                <strong><?php echo e($totalDebit); ?></strong>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            <div class="col-md-4  float-left">
                                <br>
                                <br>

                                <p>Prepared By: <?php echo e($creditVoucher->createdby->name ?? ""); ?><br />
                                    Date:____________________
                                </p>
                            </div>
                            <div class="col-md-6 text-center">
                            </div>
                            <div class="col-md-2  ">
                                <br>
                                <br>
                                <p>Approved By:________________<br />
                                    Date:_________________</p>
                            </div>

                            <hr>


                            <div class="col-md-12 bg-success" style="text-align: center">
                                Thank you for choosing <?php echo e($companyInfo->company_name ?? 'N/A'); ?> products.
                                We believe you will be satisfied by our services.
                            </div>
                            <!-- /.col -->

                        </div>
                        <!-- Table row -->
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('backend.pages.reports.excel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\XAMPP\htdocs\jubayer\resources\views/backend/pages/settings/credit_voucher/credit_voucher_show.blade.php ENDPATH**/ ?>