

<?php $__env->startSection('title', 'Show Stock Out'); ?>

<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Show Stock Out</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('stockin.list')); ?>">Stock In</a></li>
                    <li class="breadcrumb-item active">Show</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="row justify-content-center">
    <div class="col-md-11">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Stock Out Details</h3>
            </div>

            <div class="card-body">

          <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="stock-out-table">
                            <thead class="bg-light">
                                <tr>
                                 
                                   <th width="20%">Accessory Name</th>
                                        <th width="8%">Unit</th>
                                  
                                        <th width="12%">Out Kg</th>
                                        <th width="12%">Out Quantity</th>
                                        <th width="23%">Description</th>
                                      


                                </tr>
                            </thead>
                            <tbody id="additional-fields-container">
                                 <?php $__currentLoopData = $stockIn->stock_in_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="dynamic-row" id="row-<?php echo e($details->id); ?>">
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="<?php echo e($details->accessories->name ?? ''); ?>" readonly>
                                            <input type="hidden" name="accessory_id[]" value="<?php echo e($details->aceesories_id); ?>">
                                            <input type="hidden" name="detail_id[]" value="<?php echo e($details->id); ?>">
                                            <input type="hidden" name="old_quantity[]" value="<?php echo e($details->in_quantity); ?>">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="<?php echo e($details->accessories->unit ?? ''); ?>" readonly>
                                        </td>
                                        
                                        <td>
                                            <input type="number" name="in_quantity[]" 
                                                class="form-control form-control-sm quantity-input"
                                                value="<?php echo e($details->in_quantity); ?>" placeholder="Enter quantity" required>
                                        </td>
                                        
                                        <td>
                                            <input type="number" name="kg[]" class="form-control form-control-sm" 
                                                value="<?php echo e($details->kg); ?>" placeholder="Enter kg">
                                        </td>
                                        <td>
                                            <textarea name="description[]" class="form-control form-control-sm" 
                                                rows="2" placeholder="Enter description"><?php echo e($details->description); ?></textarea>
                                        </td>
                                       
                                      
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            </tbody>
                          
                        </table>
                    </div>
              

            </div>

            <div class="card-footer">
                <a href="<?php echo e(route('stockOut.list')); ?>" class="btn btn-secondary">Back to List</a>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/stockout/show.blade.php ENDPATH**/ ?>