
<?php $__env->startSection('title'); ?>
    Hrm - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }

        div#ui-datepicker-div {
            background: #fff;
            padding: 10px 20px;
            margin-top: -6px;
            border: 1px solid #e6e6e6;
        }

        div#ui-datepicker-div table tbody tr td {
            border: 1px solid rgb(173, 173, 173)
        }

        div#ui-datepicker-div table tbody tr td a {
            color: #000
        }

        @media  print {
            @page  {
                size: A4 landscape;
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
                font-size: 11px;
            }

            .btn,
            .paynow,
            .fa-money-bill {
                display: none !important;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            th,
            td {
                border: 1px solid #000;
                padding: 4px;
                word-break: break-word;
            }

            h5 {
                margin: 0;
                padding: 10px 0;
                text-align: center;
            }



        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        HRM </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        
                        <li class="breadcrumb-item active"><span><?php echo e($title); ?></span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Salary Pay Sheet</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body hide_div">
                    <form action="<?php echo e(route('hrm.paysheet.index')); ?>" method="get">

                        <div class="form-group row">
                            <div class="col-md-3">
                                <label for="employe" class="mt-2">Employee:</label>
                                <select name="employee_id" class="form-control select2" id="employe">
                                    <option value="all" selected>All</option>
                                    <?php $__currentLoopData = $employees->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($request->employee_id == $employee->id ? 'selected' : ''); ?>

                                            value="<?php echo e($employee->id); ?>">
                                            <?php echo e($employee->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="From" class="mt-2">Select Month:</label>
                                <input type="month" id="From" value="<?php echo e($request->month); ?>" class="form-control"
                                    name="month">
                                <span class="input-group-addon">
                                    <span class="glyphicon glyphicon-calendar"></span>
                                </span>
                            </div>

                            
                            <div class="col-md-1" style="margin-top:38px">
                                <button class="btn btn-success">Search</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->
    </div>

    <div class="row">
        <button onclick="printShitCard()" class="btn btn-primary mb-3 ml-3">
            <!-- SVG icon -->
            Print
        </button>

        <div class="col-md-12 shit_Card">
            <div class="card card-default">
                <!-- /.card-header -->
                <div class="card-body ">

                    <h5 class="text-center mt-3">Salary Pay Sheet History </h5>
                    <table class="table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th scope="col">SL</th>
                                <th scope="col">Name</th>
                             
                                 <th scope="col">Overtime Deduction Houre</th>
                                <th scope="col">Overtime Deduction Salary (OS)</th>
                               
                              
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($MonthlyPaySheets)): ?>
                                <?php $__currentLoopData = $MonthlyPaySheets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $MonthlyPaySheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                        <td><?php echo e($MonthlyPaySheet->name); ?></td>
                                      
                                        <td><?php echo e($MonthlyPaySheet->overtime_houre); ?>h </td>
                                        <td><?php echo e($MonthlyPaySheet->overtime_salary); ?> </td>
                                     
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php elseif(isset($tables)): ?>
                                <?php
                                    $total_salary = 0;
                                    $employee_payable_salary = 0;
                                ?>
                                <?php $__currentLoopData = $tables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($table['id_card']); ?></td>
                                        <td><?php echo e($table['name']); ?></td>
                                     
                                            <td><?php echo e($table['overtime_deduction_houre']); ?> </td>
                                        <td><?php echo e($table['overtime_deduction_salary']); ?> </td>
                                      
                                      
                                    </tr>
                                    <?php
                                        $total_salary += $table['total_salary'];
                                        $employee_payable_salary += $table['employee_payable_salary'];
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="22"></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>


                    </table>


                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->


    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let from = document.getElementById("From");
            let today = new Date();
            let currentMonth = today.toISOString().slice(0, 7); // Format: YYYY-MM

            from.setAttribute("max", currentMonth);
        });

        $(document).on('click', '.paynow', function() {
            let url = $(this).attr('href');
            $('form').attr('action', url);
            let payable = $(this).closest('tr').find('.payable').text();
            $('.showpayable').text(payable)
            $('.payamount').val(Number(payable))
            let loanamount = $(this).closest('tr').find('.loanamount').text();
            $('.showloanamount').text(loanamount);
            let loanAdjustment = $(this).closest('tr').find('.loanAdjustment').text();
            $('.showloanadj').text(loanAdjustment);
        })
    </script>
    <script>
        function printShitCard() {
            var content = document.querySelector('.shit_Card').innerHTML;
            var printWindow = window.open('', '', 'height=800,width=1200');

            printWindow.document.write('<html><head><title>Print Salary Sheet</title>');

            // Optional: Include your CSS or Bootstrap
            printWindow.document.write('<link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">');

            // Custom styles for print
            printWindow.document.write(`
            <style>
                @media  print {
                    @page  {
                        size: A4 landscape;
                       margin: 0;
                    }
                                .no-print {
        display: none !important;
    }
                    body {
                        font-size: 12px;
                    }
                    .btn, .paynow, .fa-money-bill {
                        display: none !important;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                    }
                    table th, table td {
                        padding: 6px;
                        border: 1px solid #000;
                        word-break: break-word;
                    }


                }
            </style>
        `);

            printWindow.document.write('</head><body>');
            printWindow.document.write(content);
            printWindow.document.write('</body></html>');

            printWindow.document.close();
            printWindow.focus();

            printWindow.onload = function() {
                printWindow.print();
            };

            printWindow.onafterprint = function() {
                printWindow.close();
            };
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/hrm/attendance/paysheet/overtime.blade.php ENDPATH**/ ?>