<?php
  use App\Helpers\Helper;
  $company = \App\Models\Company::where('status', 'Active')->first();
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
  <title><?php echo e(__('Buyer\'s Panel |')); ?> <?php echo $__env->yieldContent('title'); ?></title>
  <?php if(isset($company->favicon)): ?>
    <link rel="shortcut icon" href="<?php echo e(asset('/backend/favicon/' . $company->favicon)); ?>" type="image/x-icon">
  <?php endif; ?>
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback" />
  <link rel="stylesheet" href="<?php echo e(asset('backend/assets/plugins/fontawesome-free/css/all.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('backend/assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('backend/assets/dist/css/adminlte.min.css')); ?>" />
  <style>
    body {
      background: linear-gradient(to bottom right, #01680f, #03880e, #0d6402) !important;
    }
  </style>
  <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="hold-transition login-page" style="background: lightgray;">
  <div class="login-box">
    <div class="login-logo"></div><!-- /.login-logo -->
    <div class="card card-outline card-primary">
      <div class="card-body login-card-body">
        <?php if(isset($company['logo'])): ?>
          <img style="display: block;margin-left: auto;margin-right: auto;" src="<?php echo e(asset('/backend/logo/' . ($company['logo'] ?? 0))); ?>" class="img-thumbnail " alt="Responsive image" />
        <?php else: ?>
          <h6 style="color: red"><?php echo e(__('ops! your logo missing')); ?></h6>
        <?php endif; ?>
        <?php echo $__env->yieldContent('note'); ?>
        <?php echo $__env->yieldContent('content'); ?>
      </div><!-- /.login-card-body -->
    </div>
  </div><!-- /.login-box -->
  <script src="<?php echo e(asset('backend/assets/plugins/jquery/jquery.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/assets/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/assets/dist/js/adminlte.min.js')); ?>"></script>
  <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH F:\XAMPP\htdocs\jubayer\resources\views/frontant/layouts/auth.blade.php ENDPATH**/ ?>