
<?php $__env->startSection('title'); ?>
    inventory - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 font-weight-bold">
                        Total Due: <?php echo e($supplierDue); ?> &#2547;
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Supplier Due List</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Supplier List</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('inventorySetup.supplier.due')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="from_date">From Date</label>
                                <input type="date" id="from_date" name="from_date"
                                    value="<?php echo e(request('from_date')); ?>"
                                    class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label for="to_date">To Date</label>
                                <input type="date" id="to_date" name="to_date"
                                    value="<?php echo e(request('to_date')); ?>"
                                    class="form-control">
                            </div>

                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Search</button>
                                <a href="<?php echo e(route('inventorySetup.supplier.due')); ?>" class="btn btn-secondary ml-2">Reset</a>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Supplier Name</th>
                                    <th>Image</th>
                                    <th>Address</th>
                                    <th>Supplier Due (&#2547;)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $supplierDueList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($data->name); ?> (<?php echo e($data->phone); ?>)</td>
                                        <td>
                                                 <?php if(!empty($data->image)): ?>
    <img src="<?php echo e(asset('/backend/logo/' . $data->image)); ?>"
         style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
         alt="Supplier Image">
<?php else: ?>
    <img src="<?php echo e(asset('/backend/logo/default.png')); ?>"
         style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
         alt="Default Supplier Image">
<?php endif; ?>
                                            
                                        </td>
                                        <td><?php echo e($data->address); ?></td>
                                        <td><?php echo e(number_format($data->totalDue, 2)); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('inventorySetup.supplier.show',$data->id)); ?>" class="btn btn-sm btn-info">View</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($supplierDueList->isEmpty()): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No data found for selected date range.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('backend.pages.inventories.supplier.supplierDueScript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/inventories/supplier/due.blade.php ENDPATH**/ ?>