<?php $__env->startSection('title', 'Edit Stock Out'); ?>

<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Edit Stock Out</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('stockOut.list')); ?>">Stock Out</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="row justify-content-center">
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Edit Stock Out</h3>
            </div>

            <form action="<?php echo e(route('stockOut.update', $stockOut->id)); ?>" method="POST" id="edit-stockin-form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="card-body">
                    <!-- Accessory Selection Section -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="accessory_name">Accessory Name</label>
                                <select name="accessory_name" id="accessory_name"
                                    class="form-control <?php $__errorArgs = ['accessory_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">Select Accessory</option>
                                    <?php if(auth()->user()->role_id > 1): ?>
                                        <?php $__currentLoopData = App\Models\Accesories::where('branch_id', auth()->user()->branch_id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accessory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $stock = \App\Models\stockinsummary::where('product_id', $accessory->id)->sum('quantity');
                                                $stockKg = \App\Models\stockinsummary::where(
                                                        'product_id',
                                                        $accessory->id,
                                                    )->sum('kg');
                                            ?>
                                            <option value="<?php echo e($accessory->name); ?>" data-id="<?php echo e($accessory->id); ?>"
                                                data-unit="<?php echo e($accessory->unit); ?>" data-stock="<?php echo e($stock); ?>"  
                                                <?php echo e($stockOut->accessory_id == $accessory->id ? 'selected' : ''); ?>>
                                                <?php echo e($accessory->name); ?> (Stock: Qty:<?php echo e($stock); ?>, Kg:<?php echo e($stockKg); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?> 
                                        <?php $__currentLoopData = App\Models\Accesories::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accessory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $stock = \App\Models\stockinsummary::where('product_id', $accessory->id)->sum('quantity');
                                                  $stockKg = \App\Models\stockinsummary::where(
                                                        'product_id',
                                                        $accessory->id,
                                                    )->sum('kg');
                                            ?>
                                            <option value="<?php echo e($accessory->name); ?>" data-id="<?php echo e($accessory->id); ?>"
                                                data-unit="<?php echo e($accessory->unit); ?>" data-stock="<?php echo e($stock); ?>"  
                                                <?php echo e($stockOut->accessory_id == $accessory->id ? 'selected' : ''); ?>>
                                                <?php echo e($accessory->name); ?> (Stock: Qty:<?php echo e($stock); ?>, Kg:<?php echo e($stockKg); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['accessory_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3" style="display: none">
                            <div class="form-group">
                                <label for="unit">Unit</label>
                                <input type="text" name="unit" id="unit"
                                    class="form-control <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e($stockOut->accessory->unit ?? old('unit')); ?>" 
                                    placeholder="Unit will be auto-filled" readonly required>
                                <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button type="button" id="append-fields" class="btn btn-success btn-sm w-100 mb-3">
                                <i class="fa fa-plus"></i> Add
                            </button>
                        </div>
                    </div>

                    <!-- Stock Out Details Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="stock-out-table">
                            <thead class="bg-light">
                                <tr>
                                    
                                   <th width="20%">Accessory Name</th>
                                        <th width="8%">Unit</th>
                                  
                                        <th width="12%">Out Kg</th>
                                        <th width="12%">Out Quantity</th>
                                        <th width="23%">Description</th>
                                        <th width="10%">Action</th>


                                </tr>
                            </thead>
                            <tbody id="additional-fields-container">
                                <?php if($stockOut): ?>
                                    <?php $__currentLoopData = $stockOut->stock_in_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="dynamic-row" id="row-<?php echo e($details->id); ?>">
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="<?php echo e($details->accessories->name ?? ''); ?>" readonly>
                                            <input type="hidden" name="accessory_id[]" value="<?php echo e($details->aceesories_id); ?>">
                                            <input type="hidden" name="detail_id[]" value="<?php echo e($details->id); ?>">
                                            <input type="hidden" name="old_quantity[]" value="<?php echo e($details->in_quantity); ?>">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-control-sm" 
                                                value="<?php echo e($details->accessories->unit ?? ''); ?>" readonly>
                                        </td>
                                        
                                        <td>
                                            <input type="number" name="in_quantity[]" 
                                                class="form-control form-control-sm quantity-input"
                                                value="<?php echo e($details->in_quantity); ?>" placeholder="Enter quantity" required>
                                        </td>
                                        
                                        <td>
                                            <input type="number" name="kg[]" class="form-control form-control-sm" 
                                                value="<?php echo e($details->kg); ?>" placeholder="Enter kg">
                                        </td>
                                        <td>
                                            <textarea name="description[]" class="form-control form-control-sm" 
                                                rows="2" placeholder="Enter description"><?php echo e($details->description); ?></textarea>
                                        </td>
                                        
                                        <td class="text-center">
                                            <button type="button" class="btn btn-danger btn-sm remove-row" 
                                                data-row-id="row-<?php echo e($details->id); ?>">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                            
                        </table>
                    </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Update Stock Out
                    </button>
                    <a href="<?php echo e(route('stockOut.list')); ?>" class="btn btn-secondary">
                        <i class="fa fa-arrow-left"></i> Back to List
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        // Calculate grand total
        function calculateGrandTotal() {
            let grandTotal = 0;
            $('.total-price-input').each(function() {
                let value = parseFloat($(this).val()) || 0;
                grandTotal += value;
            });
            $('#grand-total').val(grandTotal.toFixed(2));
        }

        // Initial grand total calculation
        calculateGrandTotal();

        // Event listener for the accessory name change
        $('#accessory_name').on('change', function () {
            var accessoryName = $(this).val();
            var accessoryId = $(this).find(':selected').data('id');
            var unit = $(this).find(':selected').data('unit');
            if (accessoryName) {
                $('#unit').val(unit);
            } else {
                $('#unit').val('');
            }
        });

        // Auto-calculate total price on quantity or price input
        $(document).on('input', '.price-input, .quantity-input', function () {
            var $row = $(this).closest('tr');
            var price = parseFloat($row.find('.price-input').val()) || 0;
            var quantity = parseFloat($row.find('.quantity-input').val()) || 0;
            var total = price * quantity;
            $row.find('.total-price-input').val(total.toFixed(2));
            calculateGrandTotal();
        });

        // Handle append button click to add new rows
        let rowCount = <?php echo e($stockOut->stock_in_details->count() ?? 0); ?>;
        $('#append-fields').on('click', function () {
            var accessoryName = $('#accessory_name').val();
            var accessoryId = $('#accessory_name').find(':selected').data('id');
            var unit = $('#unit').val();
            
            if (accessoryName && unit) {
                rowCount++;
                var newRow = `
                    <tr class="dynamic-row" id="row-${rowCount}">
                        <td>
                            <input type="text" class="form-control form-control-sm" value="${accessoryName}" readonly>
                            <input type="hidden" name="accessory_id[]" value="${accessoryId}">
                            <input type="hidden" name="detail_id[]" value="0">
                            <input type="hidden" name="old_quantity[]" value="0">
                        </td>
                        <td>
                            <input type="text" class="form-control form-control-sm" value="${unit}" readonly>
                        </td>
                       
                        <td>
                            <input type="number" name="in_quantity[]" 
                                class="form-control form-control-sm quantity-input" 
                                placeholder="Enter quantity" required>
                        </td>
                      
                        <td>
                            <input type="number" name="kg[]" class="form-control form-control-sm" 
                                placeholder="Enter kg">
                        </td>
                        <td>
                            <textarea name="description[]" class="form-control form-control-sm" rows="2" 
                                placeholder="Enter description" required></textarea>
                        </td>
                        <td class="text-center">
                            <button type="button" class="btn btn-danger btn-sm remove-row" 
                                data-row-id="row-${rowCount}">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
                $('#additional-fields-container').append(newRow);
            } else {
                alert('Please select an accessory and unit before adding new items.');
            }
        });

        // Handle row removal
        $(document).on('click', '.remove-row', function () {
            var rowId = $(this).data('row-id');
            $('#' + rowId).remove();
            calculateGrandTotal();
        });

        // Form submission with price formatting
        $('#edit-stockin-form').submit(function () {
            $('.price-input').each(function () {
                var price = parseFloat($(this).val());
                if (!isNaN(price)) {
                    $(this).val(price.toFixed(2));
                }
            });
        });
    });
</script>

<?php $__env->startPush('styles'); ?>
<style>
    .table th {
        vertical-align: middle;
        font-size: 0.875rem;
    }
    
    .table td {
        vertical-align: middle;
        padding: 0.5rem;
    }
    
    .form-control-sm {
        font-size: 0.875rem;
    }
    
    .total-price-input {
        background-color: #f8f9fa;
        font-weight: bold;
    }
    
    #grand-total {
        background-color: #e9ecef;
        font-weight: bold;
        color: #495057;
    }
    
    .dynamic-row:hover {
        background-color: #f8f9fa;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/stockout/edit.blade.php ENDPATH**/ ?>