
<?php $__env->startSection('title'); ?>
    inventory - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
  <div class="content-header">
        <div class="container-fluid" style="padding-left:20px">
            <div class="row mb-2">
                <div class="col-sm-6 col-md-3" style="display: flex;gap:10px;border:1px solid;font-wieght:bold">
                    <h1 class="m-0" style=" font-weight: bold;   border-right: 1px solid;
    padding: 1px;
">
                        Total Due </h1>
                          <h1 class="m-0" style="font-weight: bold;">
                        <?php echo e($supplierDue); ?> &#2547;</h1>
                </div>
                <div class="col-md-3"></div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                      
                        <li class="breadcrumb-item active"><span>Supplier Due List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
    <div class="row w-100 align-items-center">

        <!-- Left Column -->
        <div class="col-md-6 d-flex align-items-center">
            <h3 class="card-title mb-0">Supplier List</h3>
        </div>

        <!-- Right Column -->
        <div class="col-md-6 text-md-right mt-2 mt-md-0">

        
         

        </div>

    </div>
</div>


                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('inventorySetup.supplier.due')); ?>" class="mb-4">
                        <div class="row">
                           

                            <div class="col-md-3">
    <select name="supplier_id" class="form-control select2" id="Supplier">
        <option value="all" <?php echo e(request('supplier_id') == 'all' ? 'selected' : ''); ?>>All</option>

        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($supplier->id); ?>"
                <?php echo e(request('supplier_id') == $supplier->id ? 'selected' : ''); ?>>
                <?php echo e($supplier->name); ?> (<?php echo e($supplier->phone); ?>)
            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>


                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Search</button>
                                <a href="<?php echo e(route('inventorySetup.supplier.due')); ?>" class="btn btn-secondary ml-2">Reset</a>
                            </div>
                        </div>
                    </form>

                     <div class="table-responsive my-2">
                          <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Supplier Name</th>
                                    <th>Image</th>
                                    <th>Address</th>
                                    <th>Supplier Due (&#2547;)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $supplierDueList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <?php
        $chartOfAccount = \App\Models\ChartOfAccount::where([
            'accountable_id'   => $data->id,
            'accountable_type' => \App\Models\Supplier::class,
        ])->first();
    ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($data->name); ?> (<?php echo e($data->phone); ?>)</td>
                                        <td>
                                                 <?php if(!empty($data->image)): ?>
                                        <img src="<?php echo e(asset('/backend/logo/' . $data->image)); ?>"
                                            style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
                                            alt="Supplier Image">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('/backend/logo/default.png')); ?>"
                                            style="height: 100px; width: 100px; border-radius: 50%; object-fit: cover; border: 2px solid #ccc;"
                                            alt="Default Supplier Image">
                                    <?php endif; ?>
                                            
                                        </td>
                                        <td><?php echo e($data->address); ?></td>
                                        <td><?php echo e(number_format($data->due_amount)); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('inventorySetup.supplier.show',$data->id)); ?>" class="btn btn-sm btn-info">View</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($supplierDueList->isEmpty()): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No data found for selected date range.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer"></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/inventories/supplier/due.blade.php ENDPATH**/ ?>