<script type="text/javascript">
    let table = $('#systemDatatable').DataTable({
        processing : true,
        serverSide : true,
        ajax : {
            url  : "<?php echo e(route('inventorySetup.customer.dataProcessingCustomerDue')); ?>",
            type : 'GET',
            data : function (d) {
                d._token    = "<?php echo e(csrf_token()); ?>";
                d.from_date = $('#from_date').val();
                d.to_date   = $('#to_date').val();
            }
        },
        columns : [
            { data : 'id',        orderable : true },
            { data : 'name',      orderable : true },
            { data : 'totalDue',  orderable : true },
            { data : 'action',    orderable : false, searchable : false, class : 'text-nowrap' },
        ],
        order: [[2, 'desc']], // 🔹 Default sort by totalDue (3rd column) in DESC order
        fnDrawCallback : function () {
            $("[name='my-checkbox']").bootstrapSwitch({
                size     : 'small',
                onColor  : 'success',
                offColor : 'danger'
            });
        }
    });

    new $.fn.dataTable.Buttons(table, {
        buttons : ['copyHtml5', 'excelHtml5', 'csvHtml5', 'pdfHtml5', 'print']
    }).container().appendTo($('#buttons'));

    $('#from_date, #to_date').on('change', function () {
        table.draw();
    });
</script>
<?php /**PATH E:\jubayer\resources\views/backend/pages/inventories/customer/dueScript.blade.php ENDPATH**/ ?>