<script type="text/javascript">
    let table = $('#systemDatatable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo e(route('hrm.award.dataProcessingAward')); ?>",
            "dataType": "json",
            "type": "GET",
            "data": {
                "_token": "<?= csrf_token() ?>"
            }
        },
        "columns": [{
                "data": "id",
                "orderable": true
            },
            {
                "data": "name",
                "orderable": true
            },
            {
                "data": "desc",
                "orderable": true
            },
            {
                "data": "gift_item",
                "orderable": true
            },
            {
                "data": "date",
                "orderable": true
            },
            {
                "data": "employee_id",
                "orderable": true
            },
            {
                "data": "award_by",
                "orderable": true
            },

            {
                "data": "action",
                "class": 'text-nowrap',
                "searchable": false,
                "orderable": false
            },
        ],

        "fnDrawCallback": function() {
            $("[name='my-checkbox']").bootstrapSwitch({
                size: "small",
                onColor: "success",
                offColor: "danger"
            });
        },

    });


    var buttons = new $.fn.dataTable.Buttons(table, {
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print',
        ]
    }).container().appendTo($('#buttons'));
</script>
<?php /**PATH I:\jubayer\resources\views/backend/pages/hrm/award/script.blade.php ENDPATH**/ ?>