<script>
    function alertMessage() {
        function error(message) {
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: message
            })
        }

        function success(message) {
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success', // Corrected to success
                title: message,
                showConfirmButton: false,
                timer: 3000 // Removed the incorrect period
            });
        }

        function confirm(message, deleteitem) {

            Swal.fire({
                title: 'Are you sure?',
                text: message,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    deleteitem();
                    Swal.fire(
                        'Deleted!',
                        'Your file has been deleted.',
                        'success'
                    )

                }
            })
        }


        function formalConfirm(message, deleteitem) {

            Swal.fire({
                title: 'Are you sure?',
                text: message,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes!'
            }).then((result) => {
                if (result.isConfirmed) {
                    deleteitem();
                    Swal.fire(
                        'Update!',
                        'Status Update SuccessFully.',
                        'success'
                    )

                }
            })
        }

        alertMessage.error = error;
        alertMessage.confirm = confirm;
        alertMessage.success = success;
        alertMessage.formalConfirm = formalConfirm;
    }

    alertMessage();
</script>
<?php /**PATH E:\jubayer\resources\views/backend/layouts/partials/alertmessage.blade.php ENDPATH**/ ?>