<?php $__env->startSection('title'); ?>
    Hrm - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        HRM </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('inventorySetup.adjust.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('hrm.attendance.index')); ?>">Hrm</a>
                            </li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span><?php echo e($title); ?></span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Attendance Log</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    
                    <form action="<?php echo e(route('hrm.absencelog.index')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <label for="employe" class="mt-2">Employee:</label>
                            <div class="col-md-3">
                                <select name="employee_id" class="form-control select2" id="employe">
                                    <option value="all">All</option>
                                    <?php $__currentLoopData = $employeeList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($request->employee_id == $employee->id ? 'selected' : ''); ?>

                                            value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <label for="From" class="mt-2">From:</label>
                            <div class="col-md-3">
                                <input type="date" id="From" value="<?php echo e($request->from ?? date('Y-m-d')); ?>"
                                    class="form-control" name="from">
                            </div>
                            <label for="To" class="mt-2">To:</label>
                            <div class="col-md-3">
                                <input type="date" id="To" value="<?php echo e($request->to ?? date('Y-m-d')); ?>"
                                    class="form-control" name="to">
                            </div>
                            <div class="col-md-1">
                                <button class="btn btn-success">Search</button>
                            </div>
                        </div>
                    </form>
                   
                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Absent List</h3>
                    <div class="card-tools">
                        <span id="buttons"></span>
                        <a class="btn btn-tool btn-default" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </a>
                        <a class="btn btn-tool btn-default" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <!-- /.card-header -->
                <div class="card-body">
                      <button class="btn btn-primary mb-3" onclick="printDiv('attendanceDiv')">Print</button>
                    <button onclick="downloadAttendancePDF()" class="btn btn-primary mb-3">Download PDF</button>
                    <div id="loadingIcon" style="display: none; text-align: center;">
                        <img src="https://cdn-icons-gif.flaticon.com/17905/17905715.gif" alt="Loading..." width="50">
                        <p>Generating PDF...</p>
                    </div>
                    <div id="attendanceDiv">
                    <table class="table table-bordered">
                       <table class="table table-bordered">
    <thead>
        <tr>
            <th scope="col">SL</th>
            <th scope="col">Employee Name</th>
            <th scope="col">ID No</th>
          
            <th scope="col">Date</th>
        </tr>
    </thead>
    <tbody>
   
       <?php $sl = 1; ?>
<?php $__empty_1 = true; $__currentLoopData = $employeeAbsents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td><?php echo e($sl++); ?></td>
        <td><?php echo e($data['employee']->name); ?></td>
        <td><?php echo e($data['employee']->id_card); ?></td>
        <td>
            <?php echo collect($data['dates'])->map(function($d) {
                return '<span style="border: 1px solid;padding:4px;margin:2px;display:inline-block;">' . \Carbon\Carbon::parse($d)->format('d-m-Y') . '</span>';
            })->implode(' '); ?>

        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
        <td colspan="4" class="text-center">No absent records found for selected date range.</td>
    </tr>
<?php endif; ?>


    </tbody>
</table>

                    </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </div>
        <!-- /.col-->
    </div>
  <script>
        function printDiv(divId) {
            const content = document.getElementById(divId).innerHTML;

            // Create a new window
            const printWindow = window.open('', '_blank', 'height=600,width=800');

            // Write the content into the new window
            printWindow.document.open();
            printWindow.document.write(`
                                   <html>
                                   <head>
                                       <title>Print</title>
                                       <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
                                       <style>
                                           body {
                                               margin: 20px;
                                           }
                                           table {
                                               width: 100%;
                                               border-collapse: collapse;
                                           }
                                           table, th, td {
                                               border: 1px solid black;
                                           }
                                       </style>
                                   </head>
                                   <body>
                                       ${content}
                                   </body>
                                   </html>
                     `);
            printWindow.document.close();

            // Wait for the content to load, then print
            printWindow.onload = function() {
                printWindow.focus();
                printWindow.print();
                printWindow.close();
            };
        }

        function downloadAttendancePDF() {
            const {
                jsPDF
            } = window.jspdf;
            let doc = new jsPDF('p', 'mm', 'a4');

            let element = document.getElementById("attendanceDiv");
            let loadingIcon = document.getElementById("loadingIcon");

            // Show loading icon
            loadingIcon.style.display = "block";

            html2canvas(element, {
                scale: 2
            }).then(canvas => {
                let imgData = canvas.toDataURL("image/png");
                let imgWidth = 190;
                let pageHeight = 297;
                let imgHeight = (canvas.height * imgWidth) / canvas.width;
                let heightLeft = imgHeight;
                let position = 10;

                doc.addImage(imgData, 'PNG', 10, position, imgWidth, imgHeight);
                heightLeft -= pageHeight;

                while (heightLeft > 0) {
                    position -= pageHeight;
                    doc.addPage();
                    doc.addImage(imgData, 'PNG', 10, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                }

                doc.save("Attendance_Report.pdf");

                // Hide loading icon after download
                loadingIcon.style.display = "none";
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/hrm/attendance/attendance-log/absent.blade.php ENDPATH**/ ?>