
<?php $__env->startSection('title'); ?>
    Report - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .bootstrap-switch-large {
            width: 200px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('navbar-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        Report </h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <?php if(helper::roleAccess('project.project.index')): ?>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('project.project.index')); ?>">Project</a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><span>Project List</span></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Stock Summary</h3>
                    <a onclick="window.print()" target="_blank" class="btn btn-default float-right my-2 no-print"><i
                            class="fas fa-print"></i>
                        Print</a>

                    <form action="<?php echo e(route('inventorySetup.currentStock.index')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <label for="categorysubmit">Search By Category</label>
                                <select name="category_id" id="categorysubmit" class="form-control select2">
                                    <option selected value="all">All Category</option>
                                    <?php $__currentLoopData = $categorys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($request->category_id == $category->id ? 'selected' : ''); ?>

                                            value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-body">

                    <div class="invoice p-3 mb-3">
                        <!-- Table row -->
                        <div class="row">
                            <div class="col-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Branch</th>
                                            <th>Product</th>
                                            <th>Type</th>
                                            <th>WearHouse Name</th>
                                            <th class="text-right">Qty</th>
                                            <?php if(auth()->user()->type == 'Admin'): ?>
                                                <th class="text-right">Avg Unit Price</th>
                                                <th class="text-right">Total</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $i = 1;
                                            $totalQty = 0;
                                            $totalPrice = 0;
                                        ?>
                                        <?php $__currentLoopData = $currentSrock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->stock_qty > 0): ?>
                                                <?php if($item->type != 'Project'): ?>
                                                    <?php
                                                        $totalQty += $item->stock_qty;
                                                    ?>
                                                    <tr>
                                                        <td><?php echo e($i++); ?></td>
                                                        <td><?php echo e(optional($item->branch)->branchCode . ' - ' . optional($item->branch)->name); ?>

                                                        </td>
                                                        <td><?php echo e(optional(optional($item->products)->category)->name . '-' . optional($item->products)->name ?? 'N/A'); ?>

                                                        </td>
                                                        <td align="right"><?php echo e($item->purchasetype); ?></td>
                                                        <td align="right"><?php echo e(optional($item->branch)->name); ?></td>
                                                        <td align="right"><?php echo e($item->stock_qty); ?></td>

                                                        <?php if(auth()->user()->type == 'Admin'): ?>
                                                            <td align="right">
                                                                <?php
                                                                    $purchasesPrices = App\Models\PurchasesDetails::where(
                                                                        'product_id',
                                                                        $item->product_id,
                                                                    )->pluck('unit_price');
                                                                    $openingStockPrices = App\Models\ProductOpeningStockDetails::where(
                                                                        'product_id',
                                                                        $item->product_id,
                                                                    )->pluck('unit_price');

                                                                    // Combine the prices into a single collection
                                                                    $allPrices = $purchasesPrices->merge(
                                                                        $openingStockPrices,
                                                                    );
                                                                    $avgPrice = $allPrices->avg();
                                                                ?>
                                                                <?php echo e($avgPrice); ?>

                                                            </td>
                                                            <td align="right"><?php echo e(round($avgPrice * $item->stock_qty, 2)); ?>

                                                            </td>
                                                        <?php endif; ?>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3" style="text-align: center">Total</th>
                                            <th style="text-align: right;"></th>
                                            <th style="text-align: right;"></th>
                                            <th style="text-align: right;"><?php echo e($totalQty); ?></th>
                                            <?php if(auth()->user()->type == 'Admin'): ?>
                                                <th style="text-align: right;"></th>
                                                <th style="text-align: right;"></th>
                                            <?php endif; ?>
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>




                            <div class="col-md-4  float-left">
                                <br>
                                <br>

                                <p>Prepared By:_____________<br />
                                    Date:____________________
                                </p>
                            </div>
                            <div class="col-md-6 text-center">
                            </div>
                            <div class="col-md-2  ">
                                <br>
                                <br>
                                <p>Approved By:________________<br />
                                    Date:_________________</p>
                            </div>

                            <hr>


                            <div class="col-md-12 bg-success" style="text-align: center">
                                Thank you for choosing <?php echo e($companyInfo->company_name ?? 'N/A'); ?> Company products.
                                We believe you will be satisfied by our services.
                            </div>
                            <!-- /.col -->



                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /.col-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#categorysubmit').on('change', function() {
                let form = $(this).closest('form');
                form.submit();
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/reports/index.blade.php ENDPATH**/ ?>