
<?php $__env->startSection('title'); ?>
    Settings - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 26px; width: 26px;
        left: 4px; bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #2196F3;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6"><h1 class="m-0">User Manage</h1></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <?php if(helper::roleAccess('usermanage.user.index')): ?>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('usermanage.user.index')); ?>">User</a></li>
                    <?php endif; ?>
                    <li class="breadcrumb-item active"><span id="page-title">User List</span></li>
                </ol>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title" id="card-title">User List</h3>
                <div class="card-tools">
                  

                    <a class="btn btn-default" href="<?php echo e(route('usermanage.user.create')); ?>">
                        <i class="fas fa-plus"></i> Add New
                    </a>
                    <span id="buttons"></span>
                    <a class="btn btn-tool btn-default" data-card-widget="collapse"><i class="fas fa-minus"></i></a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove"><i class="fas fa-times"></i></a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="userTable" class="display table-hover table table-bordered table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->index + 1); ?></td>
                                <td><?php echo e($data->name); ?></td>
                                <td><?php echo e($data->email); ?></td>
                                <td><?php echo e($data->phone); ?></td>
                                <td>
                                    <!-- Soft Delete button -->
                                    

                                    <!-- Restore button (only show if user is deleted) -->
                                    <?php if($data->deleted_at): ?>
                                    <button type="button" class="btn btn-success btn-xs restore-btn" data-id="<?php echo e($data->id); ?>" title="Restore">
                                        <i class="fas fa-undo"></i>
                                    </button>
                                    <!-- Force Delete button -->
                                    <button type="button" class="btn btn-danger btn-xs force-delete-btn" data-id="<?php echo e($data->id); ?>" title="Permanent Delete">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>SL</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="card-footer"></div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    let showDeleted = false;

    // Initialize DataTable with export buttons
    var table = $('#userTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        order: [],
    });

    // Append buttons container
    table.buttons().container().appendTo('#buttons');

    // Toggle between active and deleted users
    $('#showDeletedToggle').change(function() {
        showDeleted = $(this).prop('checked');
        $('#toggle-label').text(showDeleted ? 'Show Deleted Users' : 'Show Active Users');

        // You can implement AJAX to reload data here based on showDeleted
        // For now, just reload the page with query param as example
        let url = new URL(window.location.href);
        if(showDeleted){
            url.searchParams.set('deleted', '1');
        } else {
            url.searchParams.delete('deleted');
        }
        window.location.href = url.toString();
    });

    // Soft Delete User
    $(document).on('click', '.delete-btn', function() {
        let userId = $(this).data('id');
        let deleteRoute = "<?php echo e(url('admin/usermanage/user')); ?>/" + userId;

        Swal.fire({
            title: 'Are you sure?',
            text: "This user will be moved to trash. You can restore it later.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: deleteRoute,
                    type: 'DELETE',
                    data: {_token: '<?php echo e(csrf_token()); ?>'},
                    success: function(response) {
                        if(response.success){
                            Swal.fire('Deleted!', response.message, 'success');
                            table.row($(this).parents('tr')).remove().draw(); // Remove row on success
                            location.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr){
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    }
                });
            }
        });
    });

    // Restore User
    $(document).on('click', '.restore-btn', function() {
        let userId = $(this).data('id');
        let restoreRoute = "<?php echo e(url('admin/usermanage-user-restore')); ?>/" + userId;

        Swal.fire({
            title: 'Restore User?',
            text: "This user will be restored and made active again.",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, restore it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: restoreRoute,
                    type: 'get',
                    data: {_token: '<?php echo e(csrf_token()); ?>'},
                    success: function(response) {
                        if(response.success){
                            Swal.fire('Restored!', response.message, 'success');
                            location.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr){
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    }
                });
            }
        });
    });

    // Force Delete User (Permanent)
    $(document).on('click', '.force-delete-btn', function() {
        let userId = $(this).data('id');
        let forceDeleteRoute = "<?php echo e(url('admin/usermanage-user-forceDelete')); ?>/" + userId;

        Swal.fire({
            title: 'Permanently Delete?',
            text: "This action cannot be undone! The user will be permanently deleted from the database.",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete permanently!',
            input: 'text',
            inputPlaceholder: 'Type "DELETE" to confirm',
            preConfirm: (inputValue) => {
                if(inputValue !== 'DELETE'){
                    Swal.showValidationMessage('You need to type "DELETE" to confirm!');
                    return false;
                }
                return true;
            }
        }).then((result) => {
            if(result.isConfirmed){
                $.ajax({
                    url: forceDeleteRoute,
                    type: 'DELETE',
                    data: {_token: '<?php echo e(csrf_token()); ?>'},
                    success: function(response){
                        if(response.success){
                            Swal.fire('Permanently Deleted!', response.message, 'success');
                            location.reload();
                        } else {
                            Swal.fire('Error!', response.message, 'error');
                        }
                    },
                    error: function(xhr){
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    }
                });
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/usermanage/users/restore.blade.php ENDPATH**/ ?>