

<?php $__env->startSection('title'); ?>
  <?php echo e(__('Inventory') . ' - ' . $title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"><?php echo e(__('Inventory')); ?> </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('home')); ?>"><?php echo e(__('Dashboard')); ?></a>
            </li>
            <?php if(helper::roleAccess('inventorySetup.genre.index')): ?>
              <li class="breadcrumb-item">
                <a href="<?php echo e(route('inventorySetup.genre.index')); ?>"><?php echo e(__('Genre')); ?></a>
              </li>
            <?php endif; ?>
            <li class="breadcrumb-item active">
              <span><?php echo e(__('Genre List')); ?></span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title"><?php echo e(__('Genre List')); ?></h3>
          <div class="card-tools">
            <?php if(helper::roleAccess('inventorySetup.genre.create')): ?>
              <a class="btn btn-default" href="<?php echo e(route('inventorySetup.genre.create')); ?>">
                <i class="fas fa-plus"></i>
                <span><?php echo e(__('Add New')); ?></span>
              </a>
            <?php endif; ?>
            <span id="buttons"></span>
            <a class="btn btn-tool btn-default" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </a>
            <a class="btn btn-tool btn-default" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </a>
          </div>
        </div><!-- /.card-header -->
        <div class="card-body">
          <div class="table-responsive">
            <table id="systemDatatable" class="display table-hover table table-bordered table-striped">
              <thead>
                <tr>
                  <th><?php echo e(__('SL')); ?></th>
                  <th><?php echo e(__('Parent')); ?></th>
                  <th><?php echo e(__('Genre Name')); ?></th>
                  <th><?php echo e(__('Status')); ?></th>
                  <th><?php echo e(__('Action')); ?></th>
                </tr>
              </thead>
              <tbody></tbody>
              <tfoot>
                <tr>
                  <th><?php echo e(__('SL')); ?></th>
                  <th><?php echo e(__('Parent')); ?></th>
                  <th><?php echo e(__('Genre Name')); ?></th>
                  <th><?php echo e(__('Status')); ?></th>
                  <th><?php echo e(__('Action')); ?></th>
                </tr>
              </tfoot>
            </table>
          </div>
        </div><!-- /.card-body -->
        <div class="card-footer"></div>
      </div>
    </div><!-- /.col-->
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <?php echo $__env->make('backend.pages.inventories.genre.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/inventories/genre/index.blade.php ENDPATH**/ ?>