

<?php $__env->startSection('title'); ?>
usermanage - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<style>
/* Updated CSS for better image preview */
.image-preview-container {
    position: relative;
    display: inline-block;
    margin: 10px 0;
}

.image-preview {
    max-width: 200px;
    max-height: 200px;
    border: 2px dashed #ddd;
    border-radius: 8px;
    padding: 10px;
    /* Show preview if image exists, hide if not */
    display: <?php echo e($userDetails->logo && file_exists(public_path('/backend/logo/' . $userDetails->logo)) ? 'block' : 'none'); ?>;
}

.image-preview img {
    max-width: 100%;
    max-height: 100%;
    border-radius: 4px;
    display: block;
}

.image-remove-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    background: #dc3545;
    color: white;
    border: none;
    border-radius: 50%;
    width: 25px;
    height: 25px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
}

.image-remove-btn:hover {
    background: #c82333;
}

.file-input-wrapper {
    position: relative;
    overflow: hidden;
    display: inline-block;
    width: 100%;
}

.file-input-wrapper input[type=file] {
    position: absolute;
    left: -9999px;
}

.file-input-label {
    display: block;
    padding: 10px 15px;
    cursor: pointer;
    background: #f8f9fa;
    border: 2px dashed #ddd;
    border-radius: 8px;
    text-align: center;
    transition: all 0.3s ease;
}

.file-input-label:hover {
    background: #e9ecef;
    border-color: #007bff;
}

.file-input-label i {
    font-size: 24px;
    color: #6c757d;
    margin-bottom: 5px;
}

.file-name {
    margin-top: 5px;
    font-size: 12px;
    color: #6c757d;
}

/* Additional styles for existing file display */
.existing-file-info {
    background: #e8f5e8;
    border: 1px solid #d4edda;
    border-radius: 4px;
    padding: 10px;
    margin-top: 10px;
    font-size: 12px;
    color: #155724;
}

.existing-file-info i {
    color: #28a745;
    margin-right: 5px;
}
</style>

<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Usermanage </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <?php if(helper::roleAccess('usermanage.user.index')): ?>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('usermanage.user.index')); ?>">User List</a></li>
                    <?php endif; ?>
                    <li class="breadcrumb-item active"><span>Edit User</span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>



<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($title); ?></h3>
                <div class="card-tools">
                    <?php if(helper::roleAccess('usermanage.user.index')): ?>
                    <a class="btn btn-default" href="<?php echo e(route('usermanage.user.index')); ?>"><i class="fa fa-list"></i>
                        User List</a>
                    <?php endif; ?>
                    <span id="buttons"></span>

                    <a class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </a>
                    <a class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form class="needs-validation" method="POST"
                    action="<?php echo e(route('usermanage.user.update', $userDetails->id)); ?>" novalidate>
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Name :</label>
                            <input type="text" name="name" class="form-control" id="validationCustom01"
                                placeholder="Name" value="<?php echo e($userDetails->name); ?>">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="validationCustom02"> Email * :</label>
                            <input type="text" name="email" class="form-control" id="validationCustom02"
                                placeholder="Email" value="<?php echo e($userDetails->email); ?>">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Role Name * :</label>
                            <select name="role_name" id="" class="form-control ">
                                <option>--Select Role--</option>
                                <?php $__currentLoopData = $userRoll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($userDetails->role_id == $value->id ? 'selected' : ''); ?>

                                    value="<?php echo e($value->id); ?>"><?php echo e($value->role_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['role_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="validationCustom02"> Type *:</label>
                            <select name="type" id="utype" class="form-control select2"
                                onchange="showBranchDiv(this.value)">
                                <option <?php echo e($userDetails->type == 'Admin' ? 'selected' : ''); ?> value="Admin">Admin
                                </option>
                                <option <?php echo e($userDetails->type == 'Employee' ? 'selected' : ''); ?> value="Employee">
                                        Employee</option>
                                <!-- <option <?php echo e($userDetails->type == 'Project' ? 'selected' : ''); ?> value="Project">
                                        Project</option> -->
                            </select>
                            <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>



                        <div class="col-md-4 mb-3" id="showBranch" style="display: none">
                            <label for="validationCustom01">Branch Name * :</label>
                            <select name="branch_id" id="" class="form-control select2">
                                <!-- <option selected value="0">All Branch</option> -->
                                <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($userDetails->branch_id == $value->id ? 'selected' : ''); ?>

                                    value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-4 mb-3" >
                            <label for="validationCustom01">Employee  * :</label>
                            <select name="employee_id" id="" class="form-control select2">
                                <option selected  value="0">--Select Employee--</option>
                                <?php $__currentLoopData = $employess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $employes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($userDetails->employee_id == $employes->id ? 'selected' : ''); ?> value="<?php echo e($employes->id); ?>"><?php echo e($employes->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>


                        <div class="col-md-4 mb-3">
                            <label for="validationCustom02"> Phone * :</label>
                            <input type="text" name="phone" class="form-control" id="validationCustom02"
                                placeholder="Phone" value="<?php echo e($userDetails->phone); ?>" required>
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Password * :</label>
                            <input type="password" name="password" class="form-control" id="validationCustom01"
                                placeholder="Password" value="<?php echo e(old('password')); ?>" required>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="validationCustom01">Confirm Password * :</label>
                            <input type="password" name="password_confirmation" class="form-control"
                                id="validationCustom01" placeholder="Confirm Password"
                                value="<?php echo e(old('password_confirmation')); ?>" value="<?php echo e(old('password')); ?>" required>
                            <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class=" error text-red text-bold"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <button class="btn btn-info" type="submit"><i class="fa fa-save"></i> &nbsp;Save</button>
                </form>
            </div>
            <!-- /.card-body -->
            <div class="card-footer">

            </div>
        </div>
    </div>
    <!-- /.col-->
</div>


<script>
    function showBranchDiv(type) {
        if (type != "Project") {
            $("#showBranch").show(500);
        } else {
            $("#showBranch").hide(500);
        }
    }
</script>

<script>
    $(document).ready(function () {
        let utype = $("#utype").val();
        if (utype == "Project") {
            $("#showBranch").hide(500);
        } else {
            $("#showBranch").show(500);
        }
    });
</script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\jubayer\resources\views/backend/pages/usermanage/users/edit.blade.php ENDPATH**/ ?>