

<?php $__env->startSection('title'); ?>
Hrm - <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Hrm </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <?php if(helper::roleAccess('hrm.payroll.index')): ?>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('hrm.payroll.index')); ?>">Hrm</a>
                    </li>
                    <?php endif; ?>
                    <li class="breadcrumb-item active"><span>Lone Application Applicaitn List</span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Payroll Management</h4>
                    <div>
                        <a href="<?php echo e(route('hrm.payroll.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add New Payroll
                        </a>
                        <a href="<?php echo e(route('hrm.payroll.report')); ?>" class="btn btn-info">
                            <i class="fas fa-chart-bar"></i> Generate Report
                        </a>
                    </div>
                </div>

                <!-- Filter Form -->
                <div class="card-body border-bottom">
                    <form method="GET" action="<?php echo e(route('hrm.payroll.index')); ?>" class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Employee</label>
                            <select name="employee_id" class="form-select form-control">
                                <option value="">All Employees</option>
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($employee->id); ?>" <?php echo e(request('employee_id') == $employee->id ? 'selected' : ''); ?>>
                                        <?php echo e($employee->name); ?>(<?php echo e($employee->id_card); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Month</label>
                            <select name="month" class="form-select form-control">
                                <option value="">All Months</option>
                                <?php $__currentLoopData = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($month); ?>" <?php echo e(request('month') == $month ? 'selected' : ''); ?>>
                                        <?php echo e($month); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Year</label>
                            <select name="year" class="form-select form-control">
                                <option value="">All Years</option>
                                <?php for($year = date('Y') - 5; $year <= date('Y') + 1; $year++): ?>
                                    <option value="<?php echo e($year); ?>" <?php echo e(request('year') == $year ? 'selected' : ''); ?>>
                                        <?php echo e($year); ?>

                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <button type="submit" class="btn btn-secondary me-2">
                                <i class="fas fa-filter"></i> Filter
                            </button>
                            <a href="<?php echo e(route('hrm.payroll.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-times"></i> Clear
                            </a>
                        </div>
                    </form>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if($payrolls->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Employee</th>
                                        <th>Period</th>
                                        <th>Basic Salary</th>
                                        <th>Total Allowances</th>
                                        <th>Total Deductions</th>
                                        <th>Net Salary</th>
                                        <!-- <th>Payment Mode</th> -->
                                        <th>Pay Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php 
                                    $totalDeduction = $payroll->absent_deduction + $payroll->late_deduction + $payroll->loan_deduction + $payroll->other_deduction_pay;
                                    $totalAllowance = $payroll->overtime_pay 
                                    ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($payroll->employee->name ?? 'Employee #' . $payroll->employee_id); ?></strong>
                                            </td>
                                            <td><?php echo e($payroll->month); ?> <?php echo e($payroll->year); ?></td>
                                            <td>৳<?php echo e($payroll->basic); ?></td>
                                            <td>৳<?php echo e($payroll->total_allowance); ?></td>
                                            <td>৳<?php echo e($totalDeduction); ?></td>
                                            <td>
                                                <strong class="text-success">৳<?php echo e($payroll->net_salary); ?></strong>
                                            </td>
                                            <!-- <td>
                                                <span class="badge bg-info"><?php echo e(ucfirst(str_replace('_', ' ', $payroll->payment_mode))); ?></span>
                                            </td> -->
                                            <td><?php echo e($payroll->pay_date); ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="<?php echo e(route('hrm.payroll.show', $payroll)); ?>" class="btn btn-sm btn-outline-info" title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('hrm.payroll.edit', $payroll)); ?>" class="btn btn-sm btn-outline-warning" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <!-- <button type="button" class="btn btn-sm btn-outline-danger" title="Delete" 
                                                            onclick="confirmDelete(<?php echo e($payroll->id); ?>)">
                                                        <i class="fas fa-trash"></i>
                                                    </button> -->
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($payrolls->appends(request()->query())->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-money-bill-wave fa-5x text-muted mb-3"></i>
                            <h5 class="text-muted">No payroll records found</h5>
                            <p class="text-muted">Start by creating a new payroll record.</p>
                            <a href="<?php echo e(route('hrm.payroll.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Create First Payroll
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this payroll record? This action cannot be undone.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(payrollId) {
    const form = document.getElementById('deleteForm');
    form.action = `/payroll/${payrollId}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jubairba/soft.jubairbangladesh.com/resources/views/backend/pages/hrm/payroll/index.blade.php ENDPATH**/ ?>