<script type="text/javascript">
     const urlSegments = window.location.pathname.split('/');
    const supplierId = urlSegments[urlSegments.length - 1];

    let table = $('#systemDatatable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo e(route('inventorySetup.purchase.dataProcessingPurchaseSupplier')); ?>",
            type: "GET",
            dataType: "json",
            data: function(d) {
                d._token = "<?php echo e(csrf_token()); ?>";
                d.supplierId = supplierId;
                d.from_date = $('#from_date').val();
                d.to_date = $('#to_date').val();
            }
        },
        columns: [
            { data: "id", orderable: true },
            { data: "invoice_no", orderable: true },
            { data: "date", orderable: true },
            { data: "partialPayment", orderable: true },
            { data: "grand_total", orderable: true },
            {
                data: "action",
                class: 'text-nowrap',
                searchable: false,
                orderable: false
            },
        ],
        fnDrawCallback: function() {
            $("[name='my-checkbox']").bootstrapSwitch({
                size: "small",
                onColor: "success",
                offColor: "danger"
            });
        },
    });

    $('#from_date, #to_date').on('change', function() {
        table.draw();
    });

    new $.fn.dataTable.Buttons(table, {
        buttons: ['copyHtml5', 'excelHtml5', 'csvHtml5', 'pdfHtml5', 'print']
    }).container().appendTo($('#buttons'));
</script><?php /**PATH E:\jubayer\resources\views/backend/pages/inventories/supplier/supplierScript.blade.php ENDPATH**/ ?>