<?php $__env->startSection('title', 'Accessories List'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('navbar-content'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6"></div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                    <?php if(helper::roleAccess('sale.sale.index')): ?>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('stockOut.list')); ?>">Accessories</a></li>
                    <?php endif; ?>
                    <li class="breadcrumb-item active">Stock Out List</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="p-2 d-flex justify-content-between">
                <h3 class="card-title">Stock Out List</h3>
                <div class="card-tools">
                    <?php if(helper::roleAccess('sale.sale.create')): ?>
                        <a class="btn btn-default" href="<?php echo e(route('stockOut.create')); ?>">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                    <?php endif; ?>
                    <span id="buttons"></span>
                    <button class="btn btn-tool btn-default" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button class="btn btn-tool btn-default" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="systemDatatables" class="display table-hover table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $stockIn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($sale->created_at ? $sale->created_at->format('d-F-Y h:i A') : 'N/A'); ?></td>

                                    <td>
                                        <!-- Edit Button -->
                                        <a href="<?php echo e(route('stockOut.edit', $sale->id)); ?>" class="btn btn-primary btn-sm ml-2">
                                            <i class="bi bi-pencil"></i> Edit
                                        </a>

                                        <!-- Show Button -->
                                        <a href="<?php echo e(route('stockOut.show', $sale->id)); ?>" class="btn btn-info btn-sm ml-2">
                                            <i class="bi bi-eye"></i> Show
                                        </a>

                                        <!-- Delete Form -->
                                        
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>SL</th>
                                <th>Date</th><!-- Footer for stock -->
                                <th>Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="card-footer">
                
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH I:\jubayer\resources\views/backend/pages/stockout/index.blade.php ENDPATH**/ ?>