<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\ChartOfAccount;
use App\Models\Company;
use App\Models\Product;
use App\Models\Project;
use App\Models\QuickPurchase;
use App\Models\QuickPurchaseProduct;
use App\Models\Supplier;
use Carbon\Carbon;
use Illuminate\Http\Request;

class QuickPurchaseController extends Controller
{
    public function index()
    {
        return view('backend.pages.quick_purchase.qsalsecreate');
    }
    public function report()
    {
        
        $title = 'Quick Sale Report';
        $companyInfo = Company::latest('id')->first();
        $ledgers = ChartOfAccount::where('parent_id',0)->get();
        $projects = Project::get();
        $branch = Branch::where('status', 'Active')->get();
        $supplier = Supplier::get()->where('status', 'Active');
        $product = Product::get()->where('status', 'Active');
        return view('backend.pages.reports.quickpurchase',get_defined_vars());
    }
    public function search(Request $request)
    {
        $query = QuickPurchase::query();


        if ($request->has('branch_id') && !empty($request->branch_id)) {
            $query->where('branch_id', $request->branch_id);
        }
    
        if ($request->has('dateRange') && !empty($request->dateRange)) {
            $dates = explode(' - ', $request->dateRange);
            $fromDate = Carbon::parse($dates[0])->startOfDay();
            $toDate = Carbon::parse($dates[1])->endOfDay();
            $query->whereBetween('date', [$fromDate, $toDate]);
        }
    
        $purchaseDetails = $query->get();

       
        
    
        return view('helpers2', compact('purchaseDetails', 'fromDate', 'toDate'));
    }

    public function list()
    {
        $quickSales = QuickPurchase::all();

        return view('backend.pages.quick_purchase.quicksaleslist', get_defined_vars());
    }

    public function store(Request $request)
    {

        $grandTotal = collect($request->products)->sum('totalPrice');
        $shippingCharge = $request->input('shipping_charge', 0);
        $grandTotal += $shippingCharge;

        $discount = $request->input('discount', 0);
        $discountedTotal = $grandTotal - $discount;

        $receivedAmount = $request->input('received_amount', 0);
        $remainingBalance = $discountedTotal - $receivedAmount;


        $quickSale = QuickPurchase::create([
            'date' => $request->input('date'),
            'ledger_id' => $request->input('ledger_id'),
            'branch_id' => $request->input('branch_id'),
            'discount' => $request->discount,
            'received_amount' => 0, // Keeping original request variable name
            'payment_status' => 'due',
            'delivery_status' => $request->input('delivery_status'),
            'total_amount' => $request->reaminign,
            'due_balance' => $request->reaminign,
            'shipping_charge' => $request->shipping_charge,
        ]);


        foreach ($request->products as $product) {
            QuickPurchaseProduct::create([
                'sale_id' => $quickSale->id,
                'product_name' => $product['productName'],
                'price' => $product['price'],
                'quantity' => $product['quantity'],
                'total_price' => $product['totalPrice'],
                'productSpecification' => $product['productSpecification'],
                'fabricSpecification' => $product['fabricSpecification'],
            ]);
        }

        return redirect()->route('quickpurchase.list')->with('message', 'Order created successfully!');
    }

    public function show($id)
    {
        $order = QuickPurchase::with('products')->findOrFail($id);
        return view('backend.pages.quick_purchase.show', get_defined_vars());
    }

    public function edit($id)
    {
        $order = QuickPurchase::with('products')->findOrFail($id);
        return view('backend.pages.quick_purchase.edit', get_defined_vars());
    }
    public function update(Request $request, $id)
    {
        $quickSale = QuickPurchase::findOrFail($id);

        $quickSale->update([
            'date' => $request->input('date'),
            'ledger_id' => $request->input('ledger_id'),
            'branch_id' => $request->input('branch_id'),
            'discount' => $request->discount,
            'received_amount' => 0, // Keeping original request variable name
            'payment_status' => 'due',
            'delivery_status' => $request->input('delivery_status'),
            'total_amount' => $request->reaminign,
            'due_balance' => $request->reaminign,
            'shipping_charge' => $request->shipping_charge,
        ]);

        // Get existing product IDs from the request
        $existingProducts = is_array($request->existingProducts) ? $request->existingProducts : [];

        // Delete products that are not in the existingProducts array
        QuickPurchaseProduct::where('sale_id', $id)
            ->whereNotIn('id', $existingProducts)
            ->delete();

        // Check if new products exist in the request
        if (!empty($request->productName)) {
            foreach ($request->productName as $key => $productName) {
                $productId = $request->productid[$key] ?? null;
        
                if ($productId === "undefined" || empty($productId)) {
                    QuickPurchaseProduct::create([
                        'sale_id' => $id,
                        'product_name' => $productName, // Fixed variable reference
                        'price' => $request->price[$key] ?? 0,
                        'quantity' => $request->quantity[$key] ?? 1, // Fixed reference
                        'total_price' => $request->totalPrice[$key] ?? 0, // Fixed reference
                        'productSpecification' => $request->productSpecification[$key] ?? null, // Fixed reference
                        'fabricSpecification' => $request->fabricSpecification[$key] ?? null, // Fixed reference
                    ]);
                }
            }
        }
        

        return redirect()->route('quickpurchase.list')
            ->with('message', 'Order updated successfully!');
    }
    public function delete($id)
    {
        $quickpurchase = QuickPurchase::find($id);
        
        $quickpurchase->delete();

        return redirect()->back();
    }
}
