<?php

namespace App\Http\Controllers;

use App\Models\Accesories;
use App\Models\Stockin;  // Assuming you have a StockIn model
use App\Models\Stockindetails;
use App\Models\stockinsummary;
use App\Models\StockSummary;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

use App\Models\AccountTransaction;

use Illuminate\Http\Request;

class StockInController extends Controller
{
    // List all stock-in entries
    public function index()
    {
        $title = 'Stock In List';
        $stockIn = Stockin::all();  // Fetch all stock-in records
        return view('backend.pages.stockin.index', compact('stockIn', 'title'));  // Return the stock-in list view
    }
    public function getUnitByName($name)
    {
        // Fetch the accessory by name
        $accessory = Accesories::where('name', $name)->first();

        if ($accessory) {
            return response()->json([
                'unit' => $accessory->unit,
            ]);
        }

        return response()->json([
            'unit' => null,
        ]);
    }
    // Show the form to create a new stock-in entry
    public function create()
    {
        return view('backend.pages.stockin.create');  // Return the create form view
    }

    public function store(Request $request)
    {
        $request->validate([
            'ledger_id'  => 'required',
            'in_quantity.*'  => 'required|integer|min:1',
            'accessory_id.*' => 'required|exists:accesories,id',
            'price.*'        => 'nullable|numeric|min:0',
            'kg.*'           => 'nullable|numeric|min:0',
            'total_price.*'  => 'nullable|numeric|min:0',
        ]);
        $stock = new StockIn();
        $stock->date = today();
        $stock->ledger_id = $request->ledger_id;
        $stock->delivery_cost = $request->delivery_cost;

        $stock->save();
        foreach ($request->input('description') as $key => $description) {
            $accessoryId = $request->input('accessory_id')[$key];
            $quantity    = $request->input('in_quantity')[$key];
            $price       = $request->input('price')[$key] ?? null;
            $kg          = $request->input('kg')[$key] ?? null;
            $totalPrice  = $request->input('total_price')[$key] ?? null;

            $stockIn = new Stockindetails();
            $stockIn->aceesories_id = $accessoryId;
            $stockIn->stock_ins_id  = $stock->id;
            $stockIn->in_quantity   = $quantity;
            $stockIn->description   = $description ?? "";
            $stockIn->price         = $price;
            $stockIn->kg            = $kg;
            $stockIn->total_price   = $totalPrice;
            $stockIn->save();


            $stockSummary = stockinsummary::where('product_id', $accessoryId)
                ->first();

            if ($stockSummary) {
                $stockSummary->quantity += $quantity;
                $stockSummary->save();
            } else {
                $newStockSummary = new stockinsummary();
                $newStockSummary->product_id = $accessoryId;
                $newStockSummary->quantity = $quantity;
                $newStockSummary->save();
            }
        }


               $invoice = AccountTransaction::accountInvoice();
            $transactionPay['payment_invoice'] = $invoice;
            $transactionPay['invoice'] = $invoice;
            $transactionPay['table_id'] = $stock->id;
            $transactionPay['account_id'] = getAccountByUniqueID(22)->id; // ->purchase
            $transactionPay['type'] = 15;
            $transactionPay['branch_id'] = $branch_id ?? 0;
            $transactionPay['debit'] =  array_sum($request->total_price) + $request->delivery_cost;
            $transactionPay['remark'] = $request->narration;
            $transactionPay['created_by'] = Auth::id();
            $transactionPay['supplier_id'] = $request->supplier_id ?? 0;
            $transactionPay['created_at'] = now() ;
            AccountTransaction::create($transactionPay);

            $transaction['payment_invoice'] = $invoice;
            $transaction['invoice'] = $invoice;
            $transaction['table_id'] = $stock->id;
            $transaction['account_id'] = $request->ledger_id; // account payable
            $transaction['type'] = 15;
            $transaction['branch_id'] = $branch_id ?? 0;
            $transaction['credit'] = (array_sum($request->total_price)) + $request->delivery_cost;
            $transaction['remark'] = $request->narration;
            $transaction['created_by'] = Auth::id();
            $transaction['supplier_id'] = $request->supplier_id ?? 0;
            $transaction['created_at'] = now();
            AccountTransaction::create($transaction);


        return redirect()->route('stockin.list')->with('success', 'Stock-in created successfully.');
    }


    // Show the details of a specific stock-in entry
    public function show($id)
    {
        $stockIn = StockIn::findOrFail($id);  // Find the stock-in record by ID
        return view('backend.pages.stockin.show', compact('stockIn'));  // Return the show view
    }

    // Show the form to edit a specific stock-in entry
    public function edit($id)
    {
        $stockIn = StockIn::findOrFail($id);  // Find the stock-in record by ID
        return view('backend.pages.stockin.edit', compact('stockIn'));  // Return the edit form view
    }



    public function update(Request $request, $id)
    {
        $stockIn = StockIn::findOrFail($id);
        $existingDetailIds = $request->detail_id ?? []; // Array of submitted detail IDs

        // ✅ Delete details that were removed from the form
        Stockindetails::where('stock_ins_id', $stockIn->id)
            ->whereNotIn('id', $existingDetailIds)
            ->delete();

        foreach ($request->accessory_id as $key => $accessoryId) {
            $description   = $request->description[$key] ?? "";
            $in_quantity   = $request->in_quantity[$key];
            $old_quantity  = $request->old_quantity[$key] ?? 0;
            $price         = $request->price[$key] ?? null;
            $kg            = $request->kg[$key] ?? null;
            $total_price   = $request->total_price[$key] ?? null;


            // Check if this detail already exists
            $detail = Stockindetails::where('id', $request->detail_id[$key])->first();


            if ($detail) {
                $detail->description = $description;
                $detail->in_quantity = $in_quantity;
                $detail->price       = $price;
                $detail->kg          = $kg;
                $detail->total_price = $total_price;
            } else {
                $detail = new Stockindetails();
                $detail->stock_ins_id   = $stockIn->id;
                $detail->aceesories_id  = $accessoryId;
                $detail->description    = $description;
                $detail->in_quantity    = $in_quantity;
                $detail->price          = $price;
                $detail->kg             = $kg;
                $detail->total_price    = $total_price;
            }
            $stockSummary = stockinsummary::where('product_id', $accessoryId)
                ->first();

            if ($stockSummary) {
                $stockSummary->quantity -= $request->old_quantity[$key]; // subtract old
                $stockSummary->quantity += $in_quantity;                 // add new
                $stockSummary->save();
            } else {
                $newStockSummary = new stockinsummary();
                $newStockSummary->product_id = $accessoryId;
                $newStockSummary->quantity = $in_quantity;
                $newStockSummary->save();
            }
            $detail->save();
        }

        return redirect()->route('stockin.list')->with('success', 'Stock-in details updated successfully.');
    }


    // Delete a specific stock-in entry
    public function delete($id)
    {
        $stockIn = Stockin::findOrFail($id);  // Find the stock-in record by ID
        $stockIn->delete();  // Delete the stock-in record

        return redirect()->route('stockin.list')->with('success', 'Stock-in deleted successfully.');  // Redirect with success message
    }

    // Optionally, a report or other action related to stock-in can be added
    public function report()
    {
        // Logic for generating a stock-in report
        return view('backend.pages.stockin.report');  // Return a report view
    }
}
