<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFinishedGoodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('finished_goods', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->string('invoice_no')->nullable();
            $table->integer('order_voucher_id')->unsigned();
            $table->integer('total_qty')->nullable();
            $table->integer('approve_qty')->nullable();
            $table->integer('remarks_qty')->nullable();
            $table->json('shiping_details')->nullable();
            $table->string('status')->default('Pending');
            $table->string('note')->nullable();
            $table->integer('create_by')->nullable();
            $table->integer('update_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('finished_goods');
    }
}
