<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAttendanceStattusMarkOtLateStatusToAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('attendances', function (Blueprint $table) {
             $table->string('ot')->nullable();
             $table->enum('markStatus',['yes','no'])->default('no');
             $table->enum('attendanceStatus',['yes','no'])->default('no');
             $table->enum('lateStatus',['yes','no'])->nullable('no');
             $table->integer('lateCount')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('attendances', function (Blueprint $table) {
           $table->dropColumn('ot');
           $table->dropColumn('markStatus');
           $table->dropColumn('attendanceStatus');
          $table->dropColumn('lateStatus');
           $table->dropColumn('lateCount');
        });
    }
}
