@extends('backend.layouts.master')
@section('title')
Delivery - {{ $title }}
@endsection

@section('styles')
<style>
    .bootstrap-switch-large {
        width: 200px;
    }
    @import url("https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600&display=swap");
*, *::after, *::before {
  padding: 0;
  margin: 0;
  box-sizing: border-box;
}

h2, h4, h6 {
  margin: 0;
  padding: 0;
  display: inline-block;
}

.root {
  padding:  1.5rem;
  border-radius: 5px;
}

figure {
  display: flex;
}
figure img {
  width: 8rem;
  height: 8rem;
  border-radius: 50%;
  border: 1px solid #f05a00;
  margin-right: 1.5rem;
}
figure figcaption {
  display: flex;
  flex-direction: column;
  justify-content: space-evenly;
}
figure figcaption h4 {
  font-size: 1.4rem;
  font-weight: 500;
}
figure figcaption h6 {
  font-size: 1rem;
  font-weight: 300;
}
figure figcaption h2 {
  font-size: 1.6rem;
  font-weight: 500;
}

.order-track {
  padding: 0 1rem;
  border-top: 1px dashed #2c3e50;
  padding-top: 2.5rem;
  display: flex;
  flex-direction: column;
}
.order-track-step {
  display: flex;
  height: 73px;
}
.order-track-step:last-child {
  overflow: hidden;
  height: 4rem;
}

.order-track-status {
  margin-right: 1.5rem;
  position: relative;
}
.order-track-status-dot {
  display: block;
  width: 1.2rem;
  height: 1.2rem;
  border-radius: 50%;
  background: #0b8919;
}
.order-track-status-line {
  display: block;
  margin: 0 auto;
  width: 2px;
  height: 7rem;
  background: #0b8919;
}
.order-track-text-stat {
  font-size: 1rem;
  font-weight: 500;
  margin-bottom: 3px;
}
.order-track-text-sub {
  font-size: 1rem;
  font-weight: 300;
}

.order-track {
  transition: all 0.3s height 0.3s;
  transform-origin: top center;
}
</style>
@endsection

@section('navbar-content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">
                    Delivery </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                    @if (helper::roleAccess('finished.goods.index'))
                    <li class="breadcrumb-item"><a href="{{ route('finished.goods.index') }}">Delivery</a></li>
                    @endif
                    <li class="breadcrumb-item active"><span>Finishing Good & Shipping
                        </span></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
@endsection

@section('admin-content')
<div class="row">
    <div class="col-md-12">

        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Finishing Good & Shipping</h3>
            </div>

            <div class="card-body">

                <div class="invoice p-3 mb-3">
                    <!-- title row -->

                    <!-- info row -->
                    <div class="row invoice-info">

                        <div class="col-sm-4 ">
                            @if (isset($companyInfo->invoice_logo))
                            <a href="{{ route('home') }}">
                                <img width="200px"
                                    src="{{ asset('/backend/invoicelogo/' . $companyInfo->invoice_logo) }}" style=""
                                    alt="">
                            </a>
                            @endif
                        </div>

                        <div class="col-sm-4 invoice-col" style="text-align: center;">
                            <b style="font-size : 20px">{{ $companyInfo->company_name ?? 'N/A' }}</b>
                            <address>
                                Phone : <strong>{{ $companyInfo->phone ?? 'N/A' }}</strong><br>
                                Address : <strong><em>{{ $companyInfo->address ?? 'N/A' }}</em></strong><br>
                                Email: <strong>{{ $companyInfo->email ?? 'N/A' }}</strong>
                            </address>
                        </div>
                        <!-- /.col -->

                        <!-- /.col -->

                        <!-- /.col -->
                    </div><br>
                    <!-- /.row -->

                    <!-- Table row -->
                    <div class="row">
                        <div class="col-12 table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Product</th>
                                        <th>Size</th>
                                        <th>Color</th>
                                        <th>Unit</th>
                                        <th>Quantity</th>
                                        <th>Unit Price</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @php
                                    $totalQty = 0;
                                    $totalPrice = 0;
                                    $totalavgprice = 0;
                                    @endphp

                                    @foreach ($fgDetails as $detail)

                                    @if($detail->remaining > 0)
                                    @php
                                    $product = App\Models\OrderDetails::find($detail->product_id);
                                    $totalQty += $detail->remaining;
                                    $totalPrice += $product->rate;
                                    $totalavgprice += $product->rate *  $detail->remaining;
                                    @endphp

                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $product->goods_name ?? 'N/A' }}</td>
                                        <td>{{ $product->size ?? 'N/A' }}</td>
                                        <td>{{ $product->color ?? 'N/A' }}</td>
                                        <td>{{ $product->unit ?? 'N/A' }}</td>
                                        <td class="text-right">{{ $detail->remaining ?? 'N/A' }}</td>
                                        <td class="text-right">
                                            {{ number_format($product->rate, 2) ?? 'N/A' }}</td>
                                        <td class="text-right">
                                            {{ number_format($product->rate *  $detail->remaining , 2) ?? 'N/A' }}</td>
                                    </tr>
                                    @endif

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <th class="text-right"></th>
                                        <th class="text-right">{{ number_format($totalQty, 2) }}</th>
                                        <th class="text-right">{{ number_format($totalPrice, 2) }}</th>
                                        <th class="text-right">
                                            {{ number_format($totalavgprice, 2) ?? 'N/A' }}</th>
                                    </tr>


                                </tfoot>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row">
                      <div class="col-md-6 border-right">
                          <h5>Shipping Details</h5>
                          @php
                              $shiping_details = json_decode($fg->shiping_details);
                          @endphp
                          <table class="table table-striped table-bordered">
                              <tbody>
                                  <tr>
                                   <th>Shipping Type</th>
                                   <td>{{$shiping_details->payment_type ?? ""}}</th>
                                 </tr>
                              </tbody>
                              <tbody>
                                  <tr>
                                   <th>Company</th>
                                   <td>{{$shiping_details->company ?? ""}}</th>
                                 </tr>
                              </tbody>
                              <tbody>
                                  <tr>
                                   <th>Phone</th>
                                   <td>{{$shiping_details->phone ?? ""}}</th>
                                 </tr>
                              </tbody>
                              <tbody>
                                  <tr>
                                   <th>Address</th>
                                   <td>{{$shiping_details->address ?? ""}}</th>
                                 </tr>
                              </tbody>
                              <tbody>
                                  <tr>
                                   <th>Billing</th>
                                   <td>{{$shiping_details->biller_name ?? ""}}</th>
                                 </tr>
                              </tbody>
                          </table>
                      </div>
                        <div class="col-md-6">
                          @if(!auth()->guard('buyer')->user())
                            <form action="{{route('finished.goods.order.status',$fg->id)}}" method="post" enctype="multipart/form-data">
                                @csrf
                               <div class="row">
                                <div class="col-md-5">
                                        @php
                                          $status = false;
                                        @endphp
                                        <label for="">Status</label>
                                         <select name="status" class="select2 form-control" id="">
                                           <option disabled selected value="Pending">Pending</option>
                                           @foreach ($orders as $order)
                                            @php
                                            if($fg->status == $order->title || $fg->status == "Pending" ||  $fg->status == "Delivered"){
                                              $status = true;
                                            }
                                            @endphp
                                            <option {{$status ? "":"disabled"}} {{$fg->status == $order->title ? "selected":""}}  value="{{$order->title}}">{{$order->title}}</option>
                                            @endforeach
                                            <option {{$status ? "":"disabled"}} value="Delivered">Delivered</option>
                                         </select>
                                </div>
                                <div class="col-md-5">
                                        <label for="">FIle</label>
                                      <input type="file" name="file" class="form-control">
                                </div>
                                <div class="col-md-2 mt-2">
                                    <br>
                                    <button class="btn btn-info">Update</button>
                                </div>
                               </div>
                            </form>
                            @endif
                            <section class="root">
                                <div class="order-track">
                                @foreach ($orderstatus as $item)
                                  <div class="order-track-step mb-0">
                                    <div class="order-track-status">
                                      <span class="order-track-status-dot" style="{{($loop->last && $fg->status != "Delivered") ? "background: #f77f00" : ""}}"></span>
                                      <span class="order-track-status-line" style="{{($loop->last && $fg->status != "Delivered") ? "background: #f77f00" : ""}}"></span>
                                    </div>
                                    <div class="order-track-text">
                                      <p class="order-track-text-stat">{{$item->name}} @if($item->file)<a download="" href="{{asset('uploads/status/orders/'.$item->file)}}"><i class="fa fa-download" aria-hidden="true"></i></a>@endif</p>
                                      <span class="order-track-text-sub">{{date('d-F-Y',strtotime($item->created_at))}}</span>
                                    </div>
                                  </div>

                                  @endforeach
                                </div>
                              </section>
                        </div>
                    </div>

                    <!-- /.row -->
                    <!-- this row will not appear when printing -->
                </div>
            </div>

        </div>
    </div>
    <!-- /.col-->
</div>
@endsection
@section('scripts')
@endsection