@extends('backend.layouts.master')

@section('title')
  {{ __('Order') . ' - ' . $title }}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ !Auth::guard('web')->user() ? route('buyer.dashboard') : route('home') }}">{{ __('Dashboard') }}</a>
            </li>
              @if (helper::roleAccess('order.index'))
                <li class="breadcrumb-item">
                  <a href="{{ route('order.index') }}">{{ __('Order') }}</a>
                </li>
              @endif
            <li class="breadcrumb-item active">
              <span>{{ $title }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">{{ $title }}</h3>
        </div>
        <form action="{{ route('order.update', $order->id) }}" method="POST" >
          @csrf
          <div class="card-body">
            <div class="invoice p-3 mb-3">
              <!-- Table row -->
              <div class="row">
                <div class="col-md-2 mb-3">
                  <select name="progress_id" class="form-control select2" id="progressId" >
                    @foreach ($status as $item)  
                      <option value="{{ $item->id }}" {{ $order->progress_id == $item->id ? 'selected' : '' }} >{{ ucfirst($item->title) }}</option>
                    @endforeach
                  </select>
                </div>
                <div class="col-md-12">
                  <table class="table table-bordered">
                    <tbody>
                      <tr>
                        <th class="col-4 col-md-3">{{ __('Buyer\'s Name') }}</th>
                        <td>{{ $order->buyer->name ?? 'N/A' }}</td>
                      </tr>
                      <tr>
                        <th>{{ __('Company Name') }}</th>
                        <td>{{ $order->buyer->company_name ?? 'N/A' }}</td>
                      </tr>
                      <tr>
                        <th>{{ __('Email Address') }}</th>
                        <td>{{ $order->buyer->email ?? 'N/A' }}</td>
                      </tr>
                      <tr>
                        <th>{{ __('Cell Phone') }}</th>
                        <td>{{ $order->buyer->phone ?? 'N/A' }}</td>
                      </tr>
                      <tr>
                        <th>{{ __('Address') }}</th>
                        <td>{{ $order->buyer->address ?? 'N/A' }}</td>
                      </tr>
                    </tbody>
                  </table>
                </div>
                <div class="col-12 table-responsive">
                  <table class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th width="100px">{{ __('SL') }}</th>
                        <th>{{ __('Product') }}</th>
                        <th class="text-center" width="100px" >{{ __('Qty') }}</th>
                        {{-- <th class="text-center">{{ __('Type') }}</th> --}}
                        <th class="text-center" width="100px" >{{ __('Unit Price') }}</th>
                        <th style="text-align:right" width="150px">{{ __('Total') }}</th>
                      </tr>
                    </thead>
                    <tbody>
                      @foreach ($order->details as $key => $details)
                        <tr>
                          <td>{{ $loop->iteration }}</td>
                          <td>
                            <div class="row" >
                              <div class="col-2" >
                                <img src="{{ $details->thumbnail }}" class="w-100" alt="" width="" height="35px" />
                              </div>
                              <div class="col-10" >
                                <strong>{{ $details->goods_name }}</strong>
                              </div>
                            </div>
                          </td>
                          <td class="text-center">
                            <span class="quantity">{{ $details->quantity }}</span>
                          </td>
                          <td class="text-right">{{ number_format($details->rate, 2) . '/-' }}</td>
                          <td class="text-right">{{ number_format($details->price, 2) . '/-' }}</td>
                        </tr>
                      @endforeach
                    </tbody>
                    <tfoot>
                      <tr>
                        <th colspan="2" style="text-align: right">{{ __('TOTAl =') }}</th>
                        <td class="text-center">{{ $quantity }}</td>
                        <td></td>
                        <th class="text-right">{{ number_format($order->amount, 2) . '/-' }}</th>
                      </tr>
                      <tr>
                        <th colspan="6">In words : {{ ucfirst(Terbilang::make($order->amount)) . ' taka only.' ?? 'N/A' }}</th>
                      </tr>
                      <tr>
                        <td colspan="6"><b>Note :</b> {{ $order->note ?? 'N/A' }}</td>
                      </tr>
                    </tfoot>
                  </table>
                </div>
                <div class="col-12">
                  @if ($order->attachments )
                    <div class="row">
                      <div class="col-md-12 mb-3">{{ __('Buyer\'s Attachments') }}</div>
                      @foreach ($order->attachments->where('type', 'PO') as $key => $po)
                        <div class="col-2">
                          <div class="card card-outline card-info">
                            <div class="card-header text-right p-1">
                              <strong class="">{{ __('Attachment : ') . $loop->iteration }}</strong>
                            </div>
                            <div class="card-body p-1">
                              @php
                                $extension = pathinfo($po->attachment, PATHINFO_EXTENSION);
                              @endphp
                              @if(in_array(strtolower($extension), ['doc', 'docx', 'rtf']))
                                <img src="{{ asset('images/doc.png') }}" class="w-100" height="120px" alt="Attachment" />
                              @elseif (in_array(strtolower($extension), ['xls', 'xlsx', 'csv']))
                                <img src="{{ asset('images/xls.png') }}" class="w-100" height="120px" alt="Attachment" />
                              @elseif (in_array(strtolower($extension), ['pdf']))
                                <img src="{{ asset('images/pdf.png') }}" class="w-100" height="120px" alt="Attachment" />
                              @elseif (in_array(strtolower($extension), ['jpg', 'jpeg', 'png']))
                                <img src="{{ asset('uploads/orders/'.$po->attachment) }}" class="w-100" height="120px" alt="Attachment" />
                              @else
                                <span>{{ $po->attachment }}</span>
                              @endif
                            </div>
                            <div class="card-footer p-1">
                              <a href="{{ asset('uploads/orders/'.$po->attachment) }}" class="btn btn-sm btn-info btn-block" download >
                                <span>{{ __('Download') }}</span>
                              </a>
                            </div>
                          </div>
                        </div>
                      @endforeach
                    </div>
                    <div class="row">
                      <div class="col-md-12 mb-3">{{ __('PI Attachments') }}</div>
                      @foreach ($order->attachments->where('type', 'PI') as $key => $pi)
                        <div class="col-2">
                          <div class="card card-outline card-info">
                            <div class="card-header text-right p-1">
                              <strong class="">{{ __('Attachment : ') . $loop->iteration }}</strong>
                            </div>
                            <div class="card-body p-1">
                              @php
                                $extension = pathinfo($pi->attachment, PATHINFO_EXTENSION);
                              @endphp
                              @if (in_array(strtolower($extension), ['doc', 'docx', 'rtf']))
                                <img src="{{ asset('images/doc.png') }}" class="w-100 px-3" height="120px" alt="Attachment" />
                              @elseif (in_array(strtolower($extension), ['xls', 'xlsx', 'csv']))
                                <img src="{{ asset('images/xls.png') }}" class="w-100 px-3" height="120px" alt="Attachment" />
                              @elseif (in_array(strtolower($extension), ['pdf']))
                                <img src="{{ asset('images/pdf.png') }}" class="w-100 px-3" height="120px" alt="Attachment" />
                              @elseif (in_array(strtolower($extension), ['jpg', 'jpeg', 'png']))
                                <img src="{{ asset('uploads/orders/'.$pi->attachment) }}" class="w-100" height="120px" alt="Attachment" />
                              @else
                                <span>{{ $pi->attachment }}</span>
                              @endif
                            </div>
                            <div class="card-footer p-1">
                              <a href="{{ asset('uploads/orders/'.$pi->attachment) }}" class="btn btn-sm btn-info btn-block" download >
                                <span>{{ __('Download') }}</span>
                              </a>
                            </div>
                          </div>
                        </div>
                      @endforeach
                    </div>
                  @endif
                </div>
                <hr>
  
                <div class="col-md-12 bg-success" style="text-align: center">
                  {{ __("Thank you for choosing Our products. We believe you will be satisfied by our services.") }}
                </div><!-- /.col -->
              </div>
            </div>
            {{-- <div class="col-12"> --}}
              <button type="submit" class="btn btn-sm btn-info" >{{ __('Save') }}</button>
            {{-- </div> --}}
          </div>
        </form>
        <div class="card-footer"></div>
      </div><!-- /.col-->
    </div>
  </section>
@endsection

@section('scripts')
  <script>
    $(document).ready(function() {
      $('.rate').on('input', function() {
        var $row = $(this).closest('tr');
        var quantity = parseInt($row.find('.quantity').text());
        var rate = parseFloat($(this).val());
        var totalPrice = quantity * rate;
        $row.find('.price').val(totalPrice.toFixed(2));
      });
    });
  </script>
@endsection
