@extends('backend.layouts.master')

@section('title')
  {{ __('Order') . ' - ' . $title }}
@endsection

@section('styles')
  <style>
    .bootstrap-switch-large { width: 200px; }
  </style>
@endsection

@section('navbar-content')
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ __('Order Invoice') }}</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item">
              <a href="{{ !Auth::guard('web')->user() ? route('buyer.dashboard') : route('home') }}">{{ __('Dashboard') }}</a>
            </li>
              @if (helper::roleAccess('order.index'))
                <li class="breadcrumb-item">
                  <a href="{{ route('order.index') }}">{{ __('Order') }}</a>
                </li>
              @endif
            <li class="breadcrumb-item active">
              <span>{{ __('Order Invoice') }}</span>
            </li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
@endsection

@section('admin-content')
  <section class="row">
    <div class="col-md-12">
      <div class="card card-default">
        <div class="card-header no-print">
          <h3 class="card-title">{{ __('PO Invoice') }}</h3>
          <a onclick="window.print()" target="_blank" class="btn btn-default float-right">
            <i class="fas fa-print"></i>
            <span>{{ __('Print') }}</span>
          </a>
        </div>
        <div class="card-body">
          <div class="invoice p-3 mb-3">
            <!-- Table row -->
            <div class="row">
              <div class="col">
                <p>
                  <strong>{{ __('Style No. :') }}</strong>
                  <span>{{ $order->style_no }}</span>
                </p>
              </div>
              <div class="col">
                <p class="text-right">
                  <strong>{{ __('PO Number. :') }}</strong>
                  <span>{{ $order->po_number }}</span>
                </p>
              </div>
            </div>
            <div class="row">
              <div class="col-12 table-responsive">
                <table class="table table-striped table-bordered">
                  <thead>
                    <tr>
                      <th width="100px">{{ __('SL') }}</th>
                      <th>{{ __('Item Description') }}</th>
                      <th class="text-center" width="100px" >{{ __('Qty') }}</th>
                      <th class="text-center" width="100px" >{{ __('Unit Price') }}</th>
                      <th style="text-align:right" width="150px">{{ __('Total') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($order->details as $key => $details)
                      <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>
                          <div class="d-flex" >
                            <div style="width: 45px !important;" >
                              <img src="{{ $details->thumbnail }}" alt="" width="40px" height="40px" />
                            </div>
                            <div class="col" >
                              <strong>{{ $details->goods_name }}</strong><br>
                              <span>{{ $details->category ?? 'Not Available'}}</span>
                            </div>
                          </div>
                        </td>
                        <td class="text-center">{{ $details->quantity }}</td>
                        <td class="text-right">
                          @if (!Auth::guard('web')->user())
                            <span>{{ number_format($details->rate, 2) . '/-' }}</span>
                          @else
                            {{-- @if ($details->rate == 0)
                              <input type="number" class="form-control form-control-sm" value="{{ $details->rate }}" id="rate{{ $key }}" placeholder="Unit Price" />
                            @else --}}
                              <span>{{ number_format($details->rate, 2) . '/-' }}</span>
                            {{-- @endif --}}
                          @endif
                        </td>
                        <td class="text-right">{{ number_format($details->price, 2) . '/-' }}</td>
                      </tr>
                    @endforeach
                  </tbody>
                  <tfoot>
                    <tr>
                      <th colspan="2" style="text-align: right">{{ __('TOTAL =') }}</th>
                      <td class="text-center">{{ $quantity }}</td>
                      <td></td>
                      <th class="text-right">{{ number_format($order->amount, 2) . '/-' }}</th>
                    </tr>
                    <tr>
                      <th colspan="6">In words : {{ ucfirst(Terbilang::make($order->amount)) . ' taka only.' ?? 'N/A' }}</th>
                    </tr>
                    <tr>
                      <td colspan="6"><b>Note :</b> {{ $order->note ?? 'N/A' }}</td>
                    </tr>
                  </tfoot>
                </table>
              </div>
              <div class="col-12">
                @if ($order->attachments )
                  <div class="row">
                    <div class="col-md-12 mb-3">{{ __('Buyer\'s Attachments') }}</div>
                    @foreach ($order->attachments->where('type', 'PO') as $key => $po)
                      <div class="col-2">
                        <div class="card card-outline card-info">
                          <div class="card-header text-right p-1">
                            <strong class="">{{ __('Attachment : ') . $loop->iteration }}</strong>
                          </div>
                          <div class="card-body p-1">
                            @php
                              $extension = pathinfo($po->attachment, PATHINFO_EXTENSION);
                            @endphp
                            @if(in_array(strtolower($extension), ['doc', 'docx', 'rtf']))
                              <img src="{{ asset('images/doc.png') }}" class="w-100" height="120px" alt="Attachment" />
                            @elseif (in_array(strtolower($extension), ['xls', 'xlsx', 'csv']))
                              <img src="{{ asset('images/xls.png') }}" class="w-100" height="120px" alt="Attachment" />
                            @elseif (in_array(strtolower($extension), ['pdf']))
                              <img src="{{ asset('images/pdf.png') }}" class="w-100" height="120px" alt="Attachment" />
                            @elseif (in_array(strtolower($extension), ['jpg', 'jpeg', 'png']))
                              <img src="{{ asset('uploads/orders/'.$po->attachment) }}" class="w-100" height="120px" alt="Attachment" />
                            @else
                              <span>{{ $po->attachment }}</span>
                            @endif
                          </div>
                          <div class="card-footer p-1">
                            <a href="{{ asset('uploads/orders/'.$po->attachment) }}" class="btn btn-sm btn-info btn-block" download >
                              <span>{{ __('Download') }}</span>
                            </a>
                          </div>
                        </div>
                      </div>
                    @endforeach
                  </div>
                  <div class="row">
                    <div class="col-md-12 mb-3">{{ __('PI Attachments') }}</div>
                    @foreach ($order->attachments->where('type', 'PI') as $key => $pi)
                      <div class="col-2">
                        <div class="card card-outline card-info">
                          <div class="card-header text-right p-1">
                            <strong class="">{{ __('Attachment : ') . $loop->iteration }}</strong>
                          </div>
                          <div class="card-body p-1">
                            @php
                              $extension = pathinfo($pi->attachment, PATHINFO_EXTENSION);
                            @endphp
                            @if (in_array(strtolower($extension), ['doc', 'docx', 'rtf']))
                              <img src="{{ asset('images/doc.png') }}" class="w-100 px-3" height="120px" alt="Attachment" />
                            @elseif (in_array(strtolower($extension), ['xls', 'xlsx', 'csv']))
                              <img src="{{ asset('images/xls.png') }}" class="w-100 px-3" height="120px" alt="Attachment" />
                            @elseif (in_array(strtolower($extension), ['pdf']))
                              <img src="{{ asset('images/pdf.png') }}" class="w-100 px-3" height="120px" alt="Attachment" />
                            @elseif (in_array(strtolower($extension), ['jpg', 'jpeg', 'png']))
                              <img src="{{ asset('uploads/orders/'.$pi->attachment) }}" class="w-100" height="120px" alt="Attachment" />
                            @else
                              <span>{{ $pi->attachment }}</span>
                            @endif
                          </div>
                          <div class="card-footer p-1">
                            <a href="{{ asset('uploads/orders/'.$pi->attachment) }}" class="btn btn-sm btn-info btn-block" download >
                              <span>{{ __('Download') }}</span>
                            </a>
                          </div>
                        </div>
                      </div>
                    @endforeach
                  </div>
                @endif
              </div>
              <hr>
              <div class="col-md-12 bg-success" style="text-align: center">
                {{ __('Thank you for choosing Our products. We believe you will be satisfied by our services.') }}
              </div><!-- /.col -->
            </div>
          </div>
        </div>
      </div><!-- /.col-->
    </div>
  </section>
@endsection

@section('scripts')
@endsection
